/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.model.SensitivityZoneFactory;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.math.NumberUtils;

public class AUWorkarounds {
    public static final String COASTAL_WATERS_LAYER = "cl927";
    public static final String LGA_BOUNDARIES_LAYER = "cl23";
    static final String TSPZ_LAYER = "cl937";
    static final String TSSQZ_LAYER = "cl941";
    static final String FFEZ_TRI_STATE_LAYER = "cl938";
    static final String PCN_VIC_LAYER = "cl939";
    static final String PIZ_NSW_ALBURY_LAYER = "cl936";
    static final String PIZ_NSW_SYDNEY_LAYER = "cl940";
    static final String PIZ_VIC_NORTH_EAST_LAYER = "cl963";
    static final String PIZ_VIC_MAROONDAH_LAYER = "cl962";
    static final String PIZ_VIC_NAGAMBIE_LAYER = "cl961";
    static final String PIZ_VIC_MOOROOPNA_LAYER = "cl960";
    static final String PIZ_VIC_UPTON_LAYER = "cl964";
    static final String PIZ_VIC_WHITEBRIDGE_LAYER = "cl965";
    static final String STATES_TERRITORIES_LAYER = "cl22";
    static final String COUNTRY_LAYER = "cl932";

    public static Set<SensitivityZone> getZones(String field, String value, String latitude, String longitude) {
        SensitivityZone zone;
        HashSet<SensitivityZone> zones = new HashSet<SensitivityZone>();
        if (field.equalsIgnoreCase(COASTAL_WATERS_LAYER)) {
            String state = value.replace(" (including Coastal Waters)", "");
            state = state.replace("Captial", "Capital");
            SensitivityZone zone2 = SensitivityZoneFactory.getZoneByName(state = state.replace("Jervis Bay Territory", "Australian Capital Territory"));
            if (zone2 != null) {
                zones.add(zone2);
            }
            if (state.equalsIgnoreCase("Queensland") && (double)NumberUtils.toFloat((String)latitude) >= -19.0 && (double)NumberUtils.toFloat((String)longitude) >= 144.25) {
                zones.add(SensitivityZoneFactory.getZone("PFFPQA1995"));
            }
        } else if (field.equalsIgnoreCase(STATES_TERRITORIES_LAYER)) {
            SensitivityZone zone3 = SensitivityZoneFactory.getZoneByName(value);
            if (zone3 != null) {
                zones.add(zone3);
            }
        } else if (field.equalsIgnoreCase(LGA_BOUNDARIES_LAYER)) {
            if (value.equalsIgnoreCase("Bauhinia") || value.equalsIgnoreCase("Emerald") || value.equalsIgnoreCase("Peak Downs")) {
                zones.add(SensitivityZoneFactory.getZone("ECCPQA2004"));
            }
        } else if (field.equalsIgnoreCase(TSPZ_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("TSPZ"));
        } else if (field.equalsIgnoreCase(TSSQZ_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("TSSQZ"));
        } else if (field.equalsIgnoreCase(FFEZ_TRI_STATE_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("FFEZ"));
        } else if (field.equalsIgnoreCase(PCN_VIC_LAYER)) {
            if (value.equalsIgnoreCase("Thorpedale")) {
                zones.add(SensitivityZoneFactory.getZone("PCNCAVICTHO"));
            } else if (value.equalsIgnoreCase("Koo Wee Rup")) {
                zones.add(SensitivityZoneFactory.getZone("PCNCAVICKWR"));
            } else if (value.equalsIgnoreCase("Gembrook")) {
                zones.add(SensitivityZoneFactory.getZone("PCNCAVICGEM"));
            } else if (value.equalsIgnoreCase("Wandin")) {
                zones.add(SensitivityZoneFactory.getZone("PCNCAVICWAN"));
            }
        } else if (field.equalsIgnoreCase(PIZ_NSW_ALBURY_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("PIZNSWAC"));
        } else if (field.equalsIgnoreCase(PIZ_NSW_SYDNEY_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("PIZNSWSR"));
        } else if (field.equalsIgnoreCase(PIZ_VIC_NORTH_EAST_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("PIZVICNE"));
        } else if (field.equalsIgnoreCase(PIZ_VIC_MAROONDAH_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("PIZVICMAR"));
        } else if (field.equalsIgnoreCase(PIZ_VIC_NAGAMBIE_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("PIZVICNAG"));
        } else if (field.equalsIgnoreCase(PIZ_VIC_MOOROOPNA_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("PIZVICMOR"));
        } else if (field.equalsIgnoreCase(PIZ_VIC_UPTON_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("PIZVICUPT"));
        } else if (field.equalsIgnoreCase(PIZ_VIC_WHITEBRIDGE_LAYER) && !value.equalsIgnoreCase("n/a")) {
            zones.add(SensitivityZoneFactory.getZone("PIZVICWHB"));
        } else if (field.equalsIgnoreCase(COUNTRY_LAYER) && !value.equalsIgnoreCase("n/a") && (zone = SensitivityZoneFactory.getZone(SensitivityZone.getCountryCode(value))) != null) {
            zones.add(zone);
            if (!"AU".equals(zone.getId())) {
                zones.add(SensitivityZoneFactory.getZone("NOTAUS"));
            }
        }
        return zones;
    }
}

