/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds;

import au.org.ala.sds.Lookup;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.model.SensitiveTaxonStore;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SensitiveSpeciesFinder
implements Lookup {
    protected static final Logger logger = Logger.getLogger(SensitiveSpeciesFinder.class);
    private final SensitiveTaxonStore store;

    public SensitiveSpeciesFinder(SensitiveTaxonStore store) {
        this.store = store;
    }

    @Override
    public SensitiveTaxon findSensitiveSpecies(String scientificName) {
        return this.store.findByName(scientificName);
    }

    @Override
    public SensitiveTaxon findSensitiveSpeciesByAcceptedName(String acceptedName) {
        return this.store.findByAcceptedName(acceptedName);
    }

    @Override
    public SensitiveTaxon findSensitiveSpeciesByLsid(String lsid) {
        return this.store.findByLsid(lsid);
    }

    @Override
    public SensitiveTaxon findSensitiveSpeciesByExactMatch(String scientificName) {
        return this.store.findByExactMatch(scientificName);
    }

    @Override
    public boolean isSensitive(String scientificName) {
        return this.store.findByName(scientificName) != null;
    }

    public SensitiveTaxonStore getStore() {
        return this.store;
    }
}

