/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Date;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;

public abstract class CompareFilterImpl
extends BinaryComparisonAbstract
implements CompareFilter {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.core");

    protected CompareFilterImpl(short filterType) throws IllegalFilterException {
        super(CommonFactoryFinder.getFilterFactory(null));
        if (!CompareFilterImpl.isCompareFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create compare filter with non-compare type.");
        }
        this.filterType = filterType;
    }

    protected CompareFilterImpl(FilterFactory factory, org.opengis.filter.expression.Expression e1, org.opengis.filter.expression.Expression e2) {
        this(factory, e1, e2, true);
    }

    protected CompareFilterImpl(FilterFactory factory, org.opengis.filter.expression.Expression e1, org.opengis.filter.expression.Expression e2, boolean matchCase) {
        super(factory, e1, e2, matchCase);
    }

    @Override
    public final void addLeftValue(Expression leftValue) throws IllegalFilterException {
        this.setExpression1(leftValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setExpression1(org.opengis.filter.expression.Expression leftValue) {
        if (CompareFilterImpl.isMathFilter(this.filterType)) {
            if (!DefaultExpression.isMathExpression(leftValue) && !this.permissiveConstruction) throw new IllegalFilterException("Attempted to add non-math expression to math filter.");
            this.expression1 = leftValue;
            return;
        } else {
            this.expression1 = leftValue;
        }
    }

    @Override
    public final void addRightValue(Expression rightValue) throws IllegalFilterException {
        this.setExpression2(rightValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setExpression2(org.opengis.filter.expression.Expression rightValue) {
        if (CompareFilterImpl.isMathFilter(this.filterType)) {
            if (!DefaultExpression.isMathExpression(rightValue) && !this.permissiveConstruction) throw new IllegalFilterException("Attempted to add non-math expression to math filter.");
            this.expression2 = rightValue;
            return;
        } else {
            this.expression2 = rightValue;
        }
    }

    @Override
    public final Expression getLeftValue() {
        return (Expression)this.getExpression1();
    }

    @Override
    public final Expression getRightValue() {
        return (Expression)this.getExpression2();
    }

    @Override
    public boolean evaluate(SimpleFeature feature) {
        return this.evaluate(feature);
    }

    protected int compare(Comparable leftObj, Comparable rightObj) {
        double right;
        if (!(leftObj instanceof Number) || !(rightObj instanceof Number)) {
            if (leftObj.getClass() != rightObj.getClass()) {
                if (leftObj instanceof Date || rightObj instanceof Date) {
                    if (!(leftObj instanceof Date)) {
                        leftObj = Converters.convert(leftObj, Date.class);
                    }
                    if (!(rightObj instanceof Date)) {
                        rightObj = Converters.convert(rightObj, Date.class);
                    }
                    if (leftObj == null || rightObj == null) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    }
                } else if (leftObj instanceof Number && rightObj.getClass() == String.class) {
                    try {
                        rightObj = new Double(Double.parseDouble((String)rightObj));
                        leftObj = new Double(((Number)leftObj).doubleValue());
                    }
                    catch (Exception e) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    }
                } else if (leftObj.getClass() == String.class && rightObj instanceof Number) {
                    try {
                        leftObj = new Double(Double.parseDouble((String)leftObj));
                        rightObj = new Double(((Number)rightObj).doubleValue());
                    }
                    catch (Exception e) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    }
                } else {
                    leftObj = leftObj.toString();
                    rightObj = rightObj.toString();
                }
            } else if (leftObj instanceof String && rightObj instanceof String) {
                try {
                    leftObj = new Double(Double.parseDouble((String)leftObj));
                    rightObj = new Double(Double.parseDouble((String)rightObj));
                }
                catch (Exception e) {
                    leftObj = leftObj.toString();
                    rightObj = rightObj.toString();
                }
            }
            return leftObj.compareTo(rightObj);
        }
        double left = ((Number)leftObj).doubleValue();
        return left > (right = ((Number)rightObj).doubleValue()) ? 1 : (left == right ? 0 : -1);
    }

    public String toString() {
        if (this.filterType == 21) {
            return "[ " + this.expression1 + " IS NULL ]";
        }
        String operator = null;
        if (this.filterType == 14) {
            operator = " = ";
        }
        if (this.filterType == 15) {
            operator = " < ";
        }
        if (this.filterType == 16) {
            operator = " > ";
        }
        if (this.filterType == 17) {
            operator = " <= ";
        }
        if (this.filterType == 18) {
            operator = " >= ";
        }
        if (this.filterType == 23) {
            operator = " != ";
        }
        return "[ " + this.expression1 + operator + this.expression2 + " ]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompareFilterImpl) {
            CompareFilterImpl cFilter = (CompareFilterImpl)obj;
            short filterType = Filters.getFilterType(this);
            return filterType == Filters.getFilterType(cFilter) && (this.expression1 == cFilter.getExpression1() || this.expression1 != null && this.expression1.equals(cFilter.getExpression1())) && (this.expression2 == cFilter.getExpression2() || this.expression2 != null && this.expression2.equals(cFilter.getExpression2()));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.filterType;
        result = 37 * result + (this.expression1 == null ? 0 : this.expression1.hashCode());
        result = 37 * result + (this.expression2 == null ? 0 : this.expression2.hashCode());
        return result;
    }

    @Override
    public abstract Object accept(FilterVisitor var1, Object var2);
}

