/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.extensions;

import java.net.URI;
import java.util.Objects;
import org.gbif.dwc.extensions.Extension;
import org.gbif.dwc.extensions.Vocabulary;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;

public class ExtensionProperty
implements Comparable<ExtensionProperty>,
Term {
    private Extension extension;
    private String name;
    private String namespace;
    private String qualname;
    private String type;
    private String group;
    private int columnLength = 255;
    private String link;
    private String examples;
    private String description;
    private boolean required;
    private Vocabulary vocabulary;

    public ExtensionProperty() {
    }

    public ExtensionProperty(String qualName) {
        this.setQualname(qualName);
    }

    @Override
    public int compareTo(ExtensionProperty prop) {
        int x;
        if (this.group != null && (x = this.group.compareTo(prop.group)) != 0) {
            return x;
        }
        return this.qualname.compareTo(prop.qualname);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExtensionProperty)) {
            return false;
        }
        ExtensionProperty o = (ExtensionProperty)other;
        return Objects.equals(this.extension, o.extension) && Objects.equals(this.qualname, o.qualname);
    }

    public int getColumnLength() {
        return this.columnLength;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExamples() {
        return this.examples;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getGroup() {
        return this.group;
    }

    public String getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getQualname() {
        return this.qualname;
    }

    public String getType() {
        return this.type;
    }

    public Vocabulary getVocabulary() {
        return this.vocabulary;
    }

    public int hashCode() {
        return Objects.hash(this.extension, this.qualname);
    }

    public boolean hasTerms() {
        return this.vocabulary != null;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String qualifiedName() {
        return this.qualname;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public String prefix() {
        return "";
    }

    @Override
    public URI namespace() {
        return URI.create(this.namespace);
    }

    public String qualifiedNormalisedName() {
        return TermFactory.normaliseTerm(this.qualifiedName());
    }

    public void setColumnLength(int columnLength) {
        this.columnLength = columnLength;
    }

    public void setColumnLength(String columnLength) {
        try {
            this.columnLength = Integer.parseInt(columnLength);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExamples(String examples) {
        this.examples = examples;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setQualname(String qualname) {
        this.qualname = qualname;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setRequired(String required) {
        if ("TRUE".equalsIgnoreCase(required) || "T".equalsIgnoreCase(required) || "1".equalsIgnoreCase(required)) {
            this.required = true;
        } else if ("FALSE".equalsIgnoreCase(required) || "F".equalsIgnoreCase(required) || "0".equalsIgnoreCase(required)) {
            this.required = false;
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVocabulary(Vocabulary vocabulary) {
        this.vocabulary = vocabulary;
    }

    @Override
    public String simpleName() {
        return this.name;
    }

    @Override
    public String prefixedName() {
        return this.simpleName();
    }

    public String[] simpleNormalisedAlternativeNames() {
        return new String[0];
    }

    public String simpleNormalisedName() {
        return TermFactory.normaliseTerm(this.simpleName());
    }

    public String toString() {
        return this.qualname;
    }
}

