/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.digester;

import java.net.URL;
import org.apache.commons.digester3.Rule;
import org.gbif.dwc.extensions.ExtensionProperty;
import org.gbif.dwc.extensions.VocabulariesManager;
import org.gbif.dwc.extensions.Vocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class ThesaurusHandlingRule
extends Rule {
    private static final Logger LOG = LoggerFactory.getLogger(ThesaurusHandlingRule.class);
    public static final String ATTRIBUTE_THESAURUS = "thesaurus";
    private VocabulariesManager vocabManager;

    public ThesaurusHandlingRule(VocabulariesManager vocabManager) {
        this.vocabManager = vocabManager;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!ATTRIBUTE_THESAURUS.equals(attributes.getQName(i))) continue;
            Vocabulary tv = null;
            try {
                URL vocabURL = new URL(attributes.getValue(i));
                tv = this.vocabManager.get(vocabURL);
            }
            catch (Exception e) {
                LOG.error("Could not load vocabulary with location {}: {}", new Object[]{attributes.getValue(i), e.getMessage(), e});
            }
            if (tv != null) {
                Object extensionPropertyAsObject = this.getDigester().peek();
                if (!(extensionPropertyAsObject instanceof ExtensionProperty)) break;
                ExtensionProperty eProperty = (ExtensionProperty)extensionPropertyAsObject;
                eProperty.setVocabulary(tv);
                LOG.debug("Vocabulary with URI[{}] added to extension property", (Object)tv.getUri());
                break;
            }
            LOG.warn("No vocabulary exists for the URL[{}]", (Object)attributes.getValue(i));
            break;
        }
    }
}

