/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.Archive;
import org.gbif.dwc.ArchiveField;
import org.gbif.dwc.DwcRecordIterator;
import org.gbif.dwc.UnsupportedArchiveException;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.dwcaio.shaded.com.google.common.annotations.VisibleForTesting;
import org.gbif.utils.file.ClosableIterator;
import org.gbif.utils.file.FileUtils;
import org.gbif.utils.file.tabular.TabularDataFileReader;
import org.gbif.utils.file.tabular.TabularFileNormalizer;
import org.gbif.utils.file.tabular.TabularFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveFile
implements Iterable<Record> {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveFile.class);
    private static final FileUtils FILE_UTILS = new FileUtils();
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    public static final Term DEFAULT_ID_TERM = TERM_FACTORY.findPropertyTerm("ARCHIVE_RECORD_ID");
    public static final Character DEFAULT_FIELDS_ENCLOSED_BY = Character.valueOf('\"');
    public static final String DEFAULT_FIELDS_TERMINATED_BY = ",";
    public static final String DEFAULT_LINES_TERMINATED_BY = "\n";
    private static final Comparator<ArchiveField> AF_IDX_COMPARATOR = (o1, o2) -> {
        if (o1.getIndex() == null && o2.getIndex() == null) {
            return 0;
        }
        if (o1.getIndex() == null) {
            return -1;
        }
        if (o2.getIndex() == null) {
            return 1;
        }
        if (o1.getIndex().equals(o2.getIndex())) {
            return o1.getTerm().qualifiedName().compareTo(o2.getTerm().qualifiedName());
        }
        return o1.getIndex().compareTo(o2.getIndex());
    };
    private ArchiveField id;
    private Archive archive;
    private final LinkedList<String> locations = new LinkedList();
    private String title;
    private String fieldsTerminatedBy = ",";
    private Character fieldsEnclosedBy = DEFAULT_FIELDS_ENCLOSED_BY;
    private String linesTerminatedBy = "\n";
    private String encoding = FileUtils.UTF8;
    private Term rowType;
    private Integer ignoreHeaderLines = 0;
    private String dateFormat = "YYYY-MM-DD";
    private final Map<Term, ArchiveField> fields = new HashMap<Term, ArchiveField>();
    private final List<ArchiveField> rawArchiveFields = new ArrayList<ArchiveField>();

    public static ArchiveFile buildCsvFile() {
        ArchiveFile af = new ArchiveFile();
        af.setFieldsEnclosedBy(DEFAULT_FIELDS_ENCLOSED_BY);
        af.setFieldsTerminatedBy(DEFAULT_FIELDS_TERMINATED_BY);
        return af;
    }

    public static ArchiveFile buildTabFile() {
        ArchiveFile af = new ArchiveFile();
        af.setFieldsEnclosedBy(null);
        af.setFieldsTerminatedBy("\t");
        return af;
    }

    protected void validateAsCore(boolean hasExtensions) throws UnsupportedArchiveException {
        if (hasExtensions && this.id == null) {
            LOG.warn("DwC-A core data file \u00bb" + this.title + "\u00ab is lacking an id column. No extensions allowed in this case");
        }
        this.validate();
    }

    protected void validateAsExtension() throws UnsupportedArchiveException {
        if (this.id == null) {
            throw new UnsupportedArchiveException("DwC-A data file \u00bb" + this.title + "\u00ab requires an id or foreign key to the core id");
        }
        this.validate();
    }

    protected void validate() throws UnsupportedArchiveException {
        if (this == null) {
            throw new UnsupportedArchiveException("DwC-A data file is NULL");
        }
        if (this.getLocation() == null) {
            throw new UnsupportedArchiveException("DwC-A data file \u00bb" + this.title + "\u00ab requires a location");
        }
        if (!this.getLocationFile().exists()) {
            throw new UnsupportedArchiveException("DwC-A data file \u00bb" + this.title + "\u00ab does not exist");
        }
        if (this.encoding == null) {
            throw new UnsupportedArchiveException("DwC-A data file \u00bb" + this.title + "\u00ab requires a character encoding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean normalizeAndSort() throws IOException {
        File fileToSort = this.getLocationFile();
        File sortedFile = ArchiveFile.getLocationFileSorted(this.getLocationFile());
        File lockFile = ArchiveFile.getLocationLockFile(this.getLocationFile());
        RandomAccessFile lockFileRA = new RandomAccessFile(lockFile, "rw");
        FileLock lock = lockFileRA.getChannel().tryLock();
        if (lock == null) {
            LOG.warn("Another process has locked this DWCA for initialization; waiting until the lock is released.");
            lock = lockFileRA.getChannel().lock();
            LOG.warn("Other process has released lock; lock taken, proceeding.");
        }
        try {
            if (sortedFile.exists() && Files.getLastModifiedTime(sortedFile.toPath(), new LinkOption[0]).toInstant().isAfter(Files.getLastModifiedTime(fileToSort.toPath(), new LinkOption[0]).toInstant())) {
                LOG.debug("File {} is already sorted ({}B)", (Object)sortedFile, (Object)sortedFile.length());
                boolean bl = false;
                return bl;
            }
            File normalizedFile = this.normalizeIfRequired();
            if (normalizedFile != null) {
                fileToSort = normalizedFile;
            }
            FILE_UTILS.sort(fileToSort, ArchiveFile.getLocationFileSorted(this.getLocationFile()), this.getEncoding(), this.getId().getIndex().intValue(), this.getFieldsTerminatedBy(), this.getFieldsEnclosedBy(), TabularFileNormalizer.NORMALIZED_END_OF_LINE, this.getIgnoreHeaderLines().intValue());
            if (normalizedFile != null) {
                Files.deleteIfExists(normalizedFile.toPath());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.release();
            lockFileRA.close();
        }
    }

    @VisibleForTesting
    protected File normalizeIfRequired() throws IOException {
        boolean normalizationRequired;
        boolean bl = normalizationRequired = !TabularFileNormalizer.NORMALIZED_END_OF_LINE.equals(this.getLinesTerminatedBy()) || this.getFieldsEnclosedBy() != null;
        if (normalizationRequired) {
            File normalizedFile = ArchiveFile.getLocationFileNormalized(this.getLocationFile());
            TabularFileNormalizer.normalizeFile((Path)this.getLocationFile().toPath(), (Path)normalizedFile.toPath(), (Charset)Charset.forName(this.getEncoding()), (char)this.getFieldsTerminatedByChar(), (String)this.getLinesTerminatedBy(), (Character)this.getFieldsEnclosedBy());
            return normalizedFile;
        }
        return null;
    }

    protected static File getLocationFileNormalized(File location) {
        return new File(location.getParentFile(), location.getName() + "-normalized");
    }

    protected static File getLocationFileSorted(File location) {
        return new File(location.getParentFile(), location.getName() + "-sorted");
    }

    private static File getLocationLockFile(File location) {
        return new File(location.getParentFile(), location.getName() + "-lock");
    }

    public void addField(ArchiveField field) {
        this.fields.put(field.getTerm(), field);
        this.rawArchiveFields.add(field);
    }

    public void addLocation(String location) {
        if (this.title == null) {
            this.title = location != null && location.lastIndexOf(47) > 1 ? location.substring(location.lastIndexOf(47) + 1, location.length()) : location;
        }
        this.locations.add(location);
    }

    public Archive getArchive() {
        return this.archive;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ArchiveField getField(Term term) {
        if (term == null) {
            return null;
        }
        return this.fields.get(term);
    }

    public ArchiveField getField(String term) {
        return this.getField(TERM_FACTORY.findPropertyTerm(term));
    }

    public Map<Term, ArchiveField> getFields() {
        return this.fields;
    }

    public Character getFieldsEnclosedBy() {
        return this.fieldsEnclosedBy;
    }

    public List<ArchiveField> getFieldsSorted() {
        ArrayList<ArchiveField> list = new ArrayList<ArchiveField>(this.fields.values());
        Collections.sort(list, AF_IDX_COMPARATOR);
        return list;
    }

    public List<ArchiveField> getRawArchiveFields() {
        return new ArrayList<ArchiveField>(this.rawArchiveFields);
    }

    public List<List<Term>> getHeader() {
        Optional<Integer> idIndex;
        List archiveFieldsWithIndex = this.getFieldsSorted().stream().filter(af -> af.getIndex() != null).collect(Collectors.toList());
        Optional<Integer> optional = idIndex = this.id != null ? Optional.of(this.id.getIndex()) : Optional.empty();
        if (archiveFieldsWithIndex.isEmpty() && !idIndex.isPresent()) {
            return new ArrayList<List<Term>>();
        }
        int maxIndex = archiveFieldsWithIndex.stream().mapToInt(ArchiveField::getIndex).max().getAsInt();
        maxIndex = Math.max(maxIndex, idIndex.orElse(-1));
        ArrayList<List<Term>> terms = new ArrayList<List<Term>>();
        for (int i = 0; i <= maxIndex; ++i) {
            terms.add(new ArrayList());
        }
        archiveFieldsWithIndex.stream().forEach(af -> ((List)terms.get(af.getIndex())).add(af.getTerm()));
        idIndex.ifPresent(idx -> ((List)terms.get((int)idx)).add(DEFAULT_ID_TERM));
        return terms;
    }

    public Optional<Map<Term, String>> getDefaultValues() {
        Map<Term, String> defaultValues = this.fields.values().stream().filter(af -> StringUtils.isNotBlank((CharSequence)af.getDefaultValue())).collect(Collectors.toMap(ArchiveField::getTerm, ArchiveField::getDefaultValue));
        return defaultValues.isEmpty() ? Optional.empty() : Optional.of(defaultValues);
    }

    public String getFieldsTerminatedBy() {
        return this.fieldsTerminatedBy;
    }

    protected char getFieldsTerminatedByChar() {
        Objects.requireNonNull(this.fieldsTerminatedBy, "fieldsTerminatedBy shall be provided");
        if (this.fieldsTerminatedBy.length() != 1) {
            throw new IllegalArgumentException();
        }
        return this.fieldsTerminatedBy.charAt(0);
    }

    public ArchiveField getId() {
        return this.id;
    }

    public Integer getIgnoreHeaderLines() {
        return this.ignoreHeaderLines;
    }

    protected boolean areHeaderLinesIncluded() {
        return this.ignoreHeaderLines != null && this.ignoreHeaderLines > 0;
    }

    protected Integer getLinesToSkipBeforeHeader() {
        if (this.ignoreHeaderLines != null && this.ignoreHeaderLines > 1) {
            return this.ignoreHeaderLines - 1;
        }
        return null;
    }

    public String getLinesTerminatedBy() {
        return this.linesTerminatedBy;
    }

    public String getLocation() {
        if (this.locations.isEmpty()) {
            return null;
        }
        return this.locations.getFirst();
    }

    public File getLocationFile() {
        File dataFile;
        if (this.archive != null) {
            if (this.getLocation() == null) {
                dataFile = this.archive.getLocation();
            } else if (this.getLocation().startsWith("/")) {
                dataFile = new File(this.getLocation());
            } else {
                Path archiveLocation = this.archive.getLocation().toPath();
                File directory = Files.isDirectory(archiveLocation, new LinkOption[0]) ? archiveLocation.toFile() : archiveLocation.getParent().toFile();
                dataFile = new File(directory, this.getLocation());
            }
        } else {
            dataFile = new File(this.getLocation());
        }
        return dataFile;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public Term getRowType() {
        return this.rowType;
    }

    public Set<Term> getTerms() {
        return this.fields.keySet();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTerm(Term term) {
        return this.getField(term) != null;
    }

    public boolean hasTerm(String term) {
        return this.getField(term) != null;
    }

    @Override
    public ClosableIterator<Record> iterator() {
        return this.iterator(true, true);
    }

    private Reader getReader(boolean sorted) throws IOException {
        File file;
        File file2 = file = this.getLocationFile() != null ? this.getLocationFile() : this.getArchive().getLocation();
        if (sorted) {
            file = ArchiveFile.getLocationFileSorted(file);
        }
        return Files.newBufferedReader(file.toPath(), Charset.forName(this.getEncoding()));
    }

    public ClosableIterator<Record> iterator(boolean replaceNulls, boolean replaceEntities) {
        try {
            TabularDataFileReader tabularFileReader = TabularFiles.newTabularFileReader((Reader)this.getReader(false), (char)this.getFieldsTerminatedByChar(), (String)this.getLinesTerminatedBy(), (Character)this.getFieldsEnclosedBy(), (boolean)this.areHeaderLinesIncluded(), (Integer)this.getLinesToSkipBeforeHeader());
            return new DwcRecordIterator((TabularDataFileReader<List<String>>)tabularFileReader, this.getId(), this.getFields(), this.getRowType(), replaceNulls, replaceEntities);
        }
        catch (IOException e) {
            throw new UnsupportedArchiveException(e);
        }
    }

    protected ClosableIterator<Record> sortedIterator(boolean replaceNulls, boolean replaceEntities) throws IOException {
        TabularDataFileReader tabularFileReader = TabularFiles.newTabularFileReader((Reader)this.getReader(true), (char)this.getFieldsTerminatedByChar(), (String)TabularFileNormalizer.NORMALIZED_END_OF_LINE, (Character)this.getFieldsEnclosedBy(), (boolean)this.areHeaderLinesIncluded(), (Integer)this.getLinesToSkipBeforeHeader());
        return new DwcRecordIterator((TabularDataFileReader<List<String>>)tabularFileReader, this.getId(), this.getFields(), this.getRowType(), replaceNulls, replaceEntities);
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setEncoding(String encoding) {
        this.encoding = StringUtils.trimToNull((String)encoding);
    }

    public void setFieldsEnclosedBy(Character fieldsEnclosedBy) {
        this.fieldsEnclosedBy = fieldsEnclosedBy;
    }

    public void setFieldsTerminatedBy(String fieldsTerminatedBy) {
        this.fieldsTerminatedBy = (String)StringUtils.defaultIfEmpty((CharSequence)fieldsTerminatedBy, null);
    }

    public void setId(ArchiveField id) {
        this.id = id;
    }

    public void setIgnoreHeaderLines(Integer ignoreHeaderLines) {
        if (ignoreHeaderLines == null || ignoreHeaderLines < 0) {
            ignoreHeaderLines = 0;
        }
        this.ignoreHeaderLines = ignoreHeaderLines;
    }

    public void setLinesTerminatedBy(String linesTerminatedBy) {
        this.linesTerminatedBy = (String)StringUtils.defaultIfEmpty((CharSequence)linesTerminatedBy, null);
    }

    public void setRowType(Term rowType) {
        this.rowType = rowType;
    }

    public String toString() {
        return "ArchiveFile " + this.title;
    }
}

