/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc;

import javax.validation.constraints.NotNull;
import org.gbif.dwc.terms.Term;

public class ArchiveField {
    private Integer index;
    private Term term;
    private String defaultValue;
    private String delimitedBy;
    private String vocabulary;
    private DataType type = DataType.string;

    public ArchiveField() {
    }

    public ArchiveField(Integer index, @NotNull Term term) {
        this(index, term, null, null, null, null);
    }

    public ArchiveField(@NotNull Term term, String defaultValue) {
        this(null, term, defaultValue, null, null, null);
    }

    public ArchiveField(Integer index, @NotNull Term term, DataType type) {
        this(index, term, null, type, null, null);
    }

    public ArchiveField(Integer index, @NotNull Term term, String defaultValue, DataType type) {
        this(index, term, defaultValue, type, null, null);
    }

    public ArchiveField(Integer index, @NotNull Term term, String defaultValue, DataType type, String delimitedBy) {
        this(index, term, defaultValue, type, delimitedBy, null);
    }

    public ArchiveField(Integer index, @NotNull Term term, String defaultValue, DataType type, String delimitedBy, String vocabulary) {
        this.index = index;
        this.term = term;
        this.defaultValue = defaultValue;
        this.type = type;
        this.delimitedBy = delimitedBy;
        this.vocabulary = vocabulary;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Term getTerm() {
        return this.term;
    }

    public DataType getType() {
        return this.type;
    }

    public String getDelimitedBy() {
        return this.delimitedBy;
    }

    public String getVocabulary() {
        return this.vocabulary;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public void setDelimitedBy(String delimitedBy) {
        this.delimitedBy = delimitedBy;
    }

    public void setVocabulary(String vocabulary) {
        this.vocabulary = vocabulary;
    }

    public String toString() {
        return String.format("ArchiveField %d: %s (%s, %s, %s, %s)", new Object[]{this.index, this.term, this.vocabulary, this.type, this.delimitedBy, this.defaultValue});
    }

    public static enum DataType {
        string("xs:string"),
        bool("xs:boolean"),
        integer("xs:integer"),
        decimal("xs:decimal"),
        date("xs:dateTime"),
        uri("xs:URI");

        private final String xsdType;

        private DataType(String xsd) {
            this.xsdType = xsd;
        }

        public static DataType findByExtensionEnumTypeName(String type) {
            if (type.equalsIgnoreCase("boolean")) {
                return bool;
            }
            for (DataType dt : DataType.values()) {
                if (!dt.name().equalsIgnoreCase(type)) continue;
                return dt;
            }
            return null;
        }

        public static DataType findByXmlSchemaType(String type) {
            for (DataType dt : DataType.values()) {
                if (!dt.xsdType.equalsIgnoreCase(type)) continue;
                return dt;
            }
            return null;
        }
    }
}

