/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.SonyType1MakernoteDirectory;

public class SonyType1MakernoteDescriptor
extends TagDescriptor<SonyType1MakernoteDirectory> {
    public SonyType1MakernoteDescriptor(@NotNull SonyType1MakernoteDirectory sonyType1MakernoteDirectory) {
        super(sonyType1MakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 45089: {
                return this.getColorTemperatureDescription();
            }
            case 45091: {
                return this.getSceneModeDescription();
            }
            case 45092: {
                return this.getZoneMatchingDescription();
            }
            case 45093: {
                return this.getDynamicRangeOptimizerDescription();
            }
            case 45094: {
                return this.getImageStabilizationDescription();
            }
            case 45097: {
                return this.getColorModeDescription();
            }
            case 45120: {
                return this.getMacroDescription();
            }
            case 45121: {
                return this.getExposureModeDescription();
            }
            case 45127: {
                return this.getQualityDescription();
            }
            case 45131: {
                return this.getAntiBlurDescription();
            }
            case 45134: {
                return this.getLongExposureNoiseReductionDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getColorTemperatureDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45089);
        if (n == null) {
            return null;
        }
        if (n == 0) {
            return "Auto";
        }
        int n2 = (n & 0xFF0000) >> 8 | (n & 0xFF000000) >> 24;
        return String.format("%d K", n2);
    }

    @Nullable
    public String getSceneModeDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45091);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Standard";
            }
            case 1: {
                return "Portrait";
            }
            case 2: {
                return "Text";
            }
            case 3: {
                return "Night Scene";
            }
            case 4: {
                return "Sunset";
            }
            case 5: {
                return "Sports";
            }
            case 6: {
                return "Landscape";
            }
            case 7: {
                return "Night Portrait";
            }
            case 8: {
                return "Macro";
            }
            case 9: {
                return "Super Macro";
            }
            case 16: {
                return "Auto";
            }
            case 17: {
                return "Night View/Portrait";
            }
        }
        return String.format("Unknown (%d)", n);
    }

    @Nullable
    public String getZoneMatchingDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45092);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "ISO Setting Used";
            }
            case 1: {
                return "High Key";
            }
            case 2: {
                return "Low Key";
            }
        }
        return String.format("Unknown (%d)", n);
    }

    @Nullable
    public String getDynamicRangeOptimizerDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45093);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Standard";
            }
            case 2: {
                return "Advanced Auto";
            }
            case 8: {
                return "Advanced LV1";
            }
            case 9: {
                return "Advanced LV2";
            }
            case 10: {
                return "Advanced LV3";
            }
            case 11: {
                return "Advanced LV4";
            }
            case 12: {
                return "Advanced LV5";
            }
        }
        return String.format("Unknown (%d)", n);
    }

    @Nullable
    public String getImageStabilizationDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45094);
        if (n == null) {
            return null;
        }
        return n == 0 ? "Off" : "On";
    }

    @Nullable
    public String getColorModeDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45097);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Standard";
            }
            case 1: {
                return "Vivid";
            }
            case 2: {
                return "Portrait";
            }
            case 3: {
                return "Landscape";
            }
            case 4: {
                return "Sunset";
            }
            case 5: {
                return "Night Portrait";
            }
            case 6: {
                return "Black & White";
            }
            case 7: {
                return "Adobe RGB";
            }
            case 12: 
            case 100: {
                return "Neutral";
            }
            case 101: {
                return "Clear";
            }
            case 102: {
                return "Deep";
            }
            case 103: {
                return "Light";
            }
            case 104: {
                return "Night View";
            }
            case 105: {
                return "Autumn Leaves";
            }
        }
        return String.format("Unknown (%d)", n);
    }

    @Nullable
    public String getMacroDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45120);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Magnifying Glass/Super Macro";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", n);
    }

    @Nullable
    public String getExposureModeDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45121);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 5: {
                return "Landscape";
            }
            case 6: {
                return "Program";
            }
            case 7: {
                return "Aperture Priority";
            }
            case 8: {
                return "Shutter Priority";
            }
            case 9: {
                return "Night Scene";
            }
            case 15: {
                return "Manual";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", n);
    }

    @Nullable
    public String getQualityDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45127);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Fine";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", n);
    }

    @Nullable
    public String getAntiBlurDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45131);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On (Continuous)";
            }
            case 2: {
                return "On (Shooting)";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", n);
    }

    @Nullable
    public String getLongExposureNoiseReductionDescription() {
        Integer n = ((SonyType1MakernoteDirectory)this._directory).getInteger(45134);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", n);
    }
}

