/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.voc;

import java.util.Set;

public enum Kingdom {
    IncertaeSedis('I'),
    Animalia('A'),
    Archaea('R'),
    Bacteria('B'),
    Chromista('C'),
    Fungi('F'),
    Plantae('P'),
    Protozoa('Z'),
    Viruses('V');

    public char abbrev;

    private Kingdom(char abbrev) {
        this.abbrev = abbrev;
    }

    public Integer nameID() {
        if (IncertaeSedis == this) {
            return 9;
        }
        return this.ordinal();
    }

    public Integer usageID() {
        return this.ordinal();
    }

    public static Kingdom byNubUsageId(Integer usageID) {
        for (Kingdom term : Kingdom.values()) {
            if (term.ordinal() != usageID.intValue()) continue;
            return term;
        }
        return null;
    }

    public static Kingdom byChar(char kingdomAbbrev) {
        kingdomAbbrev = Character.toUpperCase(kingdomAbbrev);
        for (Kingdom term : Kingdom.values()) {
            if (term.abbrev != kingdomAbbrev) continue;
            return term;
        }
        return null;
    }

    public static Kingdom fromString(String x) {
        if (x == null) {
            return null;
        }
        x = x.toLowerCase().trim();
        Character kingdomAbbrev = null;
        if (x.length() == 0) {
            return null;
        }
        if (x.length() == 1) {
            kingdomAbbrev = Character.valueOf(Character.toUpperCase(x.charAt(0)));
        }
        for (Kingdom k : Kingdom.values()) {
            if (k.toString().toLowerCase().equals(x)) {
                return k;
            }
            if (kingdomAbbrev == null || kingdomAbbrev.charValue() != x.charAt(0)) continue;
            return k;
        }
        return null;
    }

    public static String getKingdomString(Set<Kingdom> kingdoms) {
        StringBuffer buf = new StringBuffer(8);
        for (Kingdom k : kingdoms) {
            if (k == null) continue;
            buf.append(k.abbrev);
        }
        return buf.toString();
    }
}

