/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.jms.ConfigurationManager;
import com.mockrunner.jms.DestinationManager;
import com.mockrunner.mock.jms.MockConnectionConsumer;
import com.mockrunner.mock.jms.MockConnectionMetaData;
import com.mockrunner.mock.jms.MockSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class MockConnection
implements Connection {
    private ConnectionMetaData metaData = new MockConnectionMetaData();
    private List sessions;
    private String clientId;
    private boolean started = false;
    private boolean closed = false;
    private ExceptionListener listener;
    private JMSException exception = null;
    private DestinationManager destinationManager;
    private ConfigurationManager configurationManager;

    public MockConnection(DestinationManager destinationManager, ConfigurationManager configurationManager) {
        this.destinationManager = destinationManager;
        this.configurationManager = configurationManager;
        this.sessions = new ArrayList();
    }

    public DestinationManager getDestinationManager() {
        return this.destinationManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public List getSessionList() {
        return Collections.unmodifiableList(this.sessions);
    }

    public MockSession getSession(int n) {
        if (this.sessions.size() <= n || n < 0) {
            return null;
        }
        return (MockSession)this.sessions.get(n);
    }

    public void setJMSException(JMSException jMSException) {
        this.exception = jMSException;
    }

    public void throwJMSException() throws JMSException {
        if (null == this.exception) {
            return;
        }
        JMSException jMSException = this.exception;
        this.exception = null;
        if (this.listener != null) {
            this.listener.onException(jMSException);
        }
        throw jMSException;
    }

    public void setMetaData(ConnectionMetaData connectionMetaData) {
        this.metaData = connectionMetaData;
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        this.throwJMSException();
        MockSession mockSession = new MockSession(this, bl, n);
        this.sessions().add(mockSession);
        return mockSession;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        this.throwJMSException();
        return new MockConnectionConsumer(this, serverSessionPool);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createConnectionConsumer((Destination)topic, string2, serverSessionPool, n);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.throwJMSException();
        return this.metaData;
    }

    public String getClientID() throws JMSException {
        this.throwJMSException();
        return this.clientId;
    }

    public void setClientID(String string) throws JMSException {
        this.throwJMSException();
        this.clientId = string;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.throwJMSException();
        return this.listener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.throwJMSException();
        this.listener = exceptionListener;
    }

    public void start() throws JMSException {
        this.throwJMSException();
        this.started = true;
    }

    public void stop() throws JMSException {
        this.throwJMSException();
        this.started = false;
    }

    public void close() throws JMSException {
        this.throwJMSException();
        for (int i = 0; i < this.sessions.size(); ++i) {
            Session session = (Session)this.sessions.get(i);
            session.close();
        }
        this.closed = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.isStarted();
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected List sessions() {
        return this.sessions;
    }
}

