/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.AbstractResultSetHandler;
import com.mockrunner.jdbc.SQLUtil;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MockStatement
implements Statement {
    private AbstractResultSetHandler resultSetHandler;
    private ResultSet currentResultSet = null;
    private int currentUpdateCount = -1;
    private List batches = new ArrayList();
    private String cursorName = "";
    private int querySeconds = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = 1;
    private MockResultSet lastGeneratedKeys = null;
    private boolean closed = false;
    private Connection connection;

    public MockStatement(Connection connection) {
        this.connection = connection;
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        try {
            this.resultSetHoldability = connection.getMetaData().getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
    }

    public MockStatement(Connection connection, int n, int n2) {
        this.connection = connection;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        try {
            this.resultSetHoldability = connection.getMetaData().getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
    }

    public MockStatement(Connection connection, int n, int n2, int n3) {
        this.connection = connection;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setResultSetHandler(AbstractResultSetHandler abstractResultSetHandler) {
        this.resultSetHandler = abstractResultSetHandler;
    }

    protected void setResultSet(ResultSet resultSet) {
        this.currentUpdateCount = -1;
        this.currentResultSet = resultSet;
    }

    protected void setUpdateCount(int n) {
        this.currentResultSet = null;
        this.currentUpdateCount = n;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        SQLException sQLException = this.resultSetHandler.getSQLException(string);
        if (null != sQLException) {
            throw sQLException;
        }
        this.resultSetHandler.addExecutedStatement(string);
        MockResultSet mockResultSet = this.resultSetHandler.getResultSet(string);
        if (null != mockResultSet) {
            mockResultSet = this.cloneResultSet(mockResultSet);
            this.resultSetHandler.addReturnedResultSet(mockResultSet);
            this.setResultSet(mockResultSet);
            return mockResultSet;
        }
        mockResultSet = this.cloneResultSet(this.resultSetHandler.getGlobalResultSet());
        this.resultSetHandler.addReturnedResultSet(mockResultSet);
        this.setResultSet(mockResultSet);
        return mockResultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        SQLException sQLException = this.resultSetHandler.getSQLException(string);
        if (null != sQLException) {
            throw sQLException;
        }
        this.resultSetHandler.addExecutedStatement(string);
        Integer n = this.resultSetHandler.getUpdateCount(string);
        if (null != n) {
            int n2 = n;
            this.setUpdateCount(n2);
            return n2;
        }
        int n3 = this.resultSetHandler.getGlobalUpdateCount();
        this.setUpdateCount(n3);
        return n3;
    }

    public boolean execute(String string) throws SQLException {
        boolean bl = this.isQuery(string);
        if (bl) {
            this.executeQuery(string);
        } else {
            this.executeUpdate(string);
        }
        return bl;
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray = new int[this.batches.size()];
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)this.batches.get(i);
            if (this.isQuery(string)) {
                throw new BatchUpdateException("SQL " + this.batches.get(i) + " in the list of batches returned a ResultSet.", null);
            }
            nArray[i] = this.executeUpdate(string);
        }
        return nArray;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        int n2 = this.executeUpdate(string);
        this.setGeneratedKeysResultSet(string, n);
        return n2;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.executeUpdate(string, 1);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.executeUpdate(string, 1);
    }

    public boolean execute(String string, int n) throws SQLException {
        boolean bl = this.execute(string);
        this.setGeneratedKeysResultSet(string, n);
        return bl;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        return this.execute(string, 1);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        return this.execute(string, 1);
    }

    private void setGeneratedKeysResultSet(String string, int n) throws SQLException {
        if (1 != n && 2 != n) {
            throw new SQLException("autoGeneratedKeys must be either Statement.RETURN_GENERATED_KEYS or Statement.NO_GENERATED_KEYS");
        }
        if (1 == n) {
            this.lastGeneratedKeys = this.resultSetHandler.getGeneratedKeys(string);
            if (null == this.lastGeneratedKeys) {
                this.lastGeneratedKeys = this.resultSetHandler.getGlobalGeneratedKeys();
            }
        } else {
            this.lastGeneratedKeys = null;
        }
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    public int getQueryTimeout() throws SQLException {
        return this.querySeconds;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.querySeconds = n;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String string) throws SQLException {
        this.cursorName = string;
    }

    protected boolean isQuery(String string) {
        Boolean bl = this.resultSetHandler.getReturnsResultSet(string);
        boolean bl2 = null != bl ? bl : SQLUtil.isSelect(string);
        return bl2;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.currentResultSet;
    }

    public int getUpdateCount() throws SQLException {
        return this.currentUpdateCount;
    }

    public boolean getMoreResults() throws SQLException {
        if (null != this.currentResultSet) {
            this.currentResultSet.close();
        }
        this.currentResultSet = null;
        this.currentUpdateCount = -1;
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public void addBatch(String string) throws SQLException {
        this.batches.add(string);
    }

    public void clearBatch() throws SQLException {
        this.batches.clear();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean getMoreResults(int n) throws SQLException {
        return this.getMoreResults();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (null == this.lastGeneratedKeys) {
            MockResultSet mockResultSet = new MockResultSet("Last statement did not generate any keys");
            mockResultSet.setStatement(this);
            return mockResultSet;
        }
        return this.cloneResultSet(this.lastGeneratedKeys);
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    protected MockResultSet cloneResultSet(MockResultSet mockResultSet) throws SQLException {
        if (null == mockResultSet) {
            return null;
        }
        MockResultSet mockResultSet2 = (MockResultSet)mockResultSet.clone();
        mockResultSet2.setStatement(this);
        return mockResultSet2;
    }
}

