/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.terms;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.gbif.dwc.terms.Term;

public class UnknownTerm
implements Term,
Serializable {
    private final URI uri;
    private final String name;
    private final boolean isClass;
    private static final String NS = "http://unknown.org/";

    public static UnknownTerm build(String name) {
        return UnknownTerm.build(name, false);
    }

    public static UnknownTerm build(String name, boolean isClass) {
        URI uri = URI.create(name);
        if (uri.getAuthority() != null) {
            return new UnknownTerm(uri, isClass);
        }
        if (uri.getScheme() != null) {
            return UnknownTerm.build(NS + uri.getScheme() + "/" + uri.getSchemeSpecificPart(), isClass);
        }
        if (!name.contains("/") && !name.contains("#")) {
            try {
                name = URLEncoder.encode(name, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return UnknownTerm.build(NS + name, isClass);
    }

    public static UnknownTerm build(String qualifiedName, String simpleName) {
        return UnknownTerm.build(qualifiedName, simpleName, false);
    }

    public static UnknownTerm build(String qualifiedName, String simpleName, boolean isClass) {
        return new UnknownTerm(URI.create(qualifiedName), simpleName, isClass);
    }

    public UnknownTerm(URI uri, String name, boolean isClass) {
        this.isClass = isClass;
        if (uri == null || !uri.isAbsolute()) {
            throw new IllegalArgumentException("The qualified name URI must be an absolute URI");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The simple name is required");
        }
        this.uri = uri;
        this.name = name;
    }

    public UnknownTerm(URI uri, boolean isClass) {
        if (uri == null || !uri.isAbsolute()) {
            throw new IllegalArgumentException("The qualified name URI is required and must be an absolute URI");
        }
        String name = null;
        if (uri.getFragment() != null) {
            name = uri.getFragment();
        } else if (uri.getPath() != null) {
            int pos;
            name = uri.getPath();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((pos = name.lastIndexOf("/")) > 0) {
                name = name.substring(pos + 1);
            }
        } else {
            throw new IllegalArgumentException("The qualified name URI must have a path or fragment to automatically derive a simple name");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The simple name is required");
        }
        this.uri = uri;
        this.name = name;
        this.isClass = isClass;
    }

    @Override
    public String qualifiedName() {
        return this.uri.toString();
    }

    @Override
    public String simpleName() {
        return this.name;
    }

    @Override
    public boolean isClass() {
        return this.isClass;
    }

    public String toString() {
        return this.qualifiedName();
    }

    @Override
    public String prefixedName() {
        return this.qualifiedName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Term)) {
            return false;
        }
        Term that = (Term)o;
        return this.qualifiedName().equals(that.qualifiedName());
    }

    public int hashCode() {
        return this.qualifiedName().hashCode();
    }

    @Override
    public String prefix() {
        return null;
    }

    @Override
    public URI namespace() {
        return URI.create(this.uri.getScheme() + "://" + this.uri.getAuthority());
    }
}

