/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.terms;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gbif.dwc.terms.AcTerm;
import org.gbif.dwc.terms.AcefTerm;
import org.gbif.dwc.terms.AlternativeNames;
import org.gbif.dwc.terms.DcElement;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifInternalTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.IucnTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.UnknownTerm;
import org.gbif.dwc.terms.XmpRightsTerm;
import org.gbif.dwc.terms.XmpTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TermFactory.class);
    private static final Pattern NON_ALPHA_NUM_PATTERN = Pattern.compile("[^a-zA-Z0-9#-]+");
    private static TermFactory singleton;
    private static boolean initialized;
    private static final Object LOCK;
    private final Map<String, Term> terms = new HashMap<String, Term>();
    private final Map<String, Term> classTerms = new HashMap<String, Term>();
    private final Set<Class<? extends Enum>> registeredEnumClasses = new HashSet<Class<? extends Enum>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TermFactory instance() {
        if (initialized) {
            return singleton;
        }
        Object object = LOCK;
        synchronized (object) {
            if (singleton == null) {
                LOG.debug("Building new TermFactory instance");
                singleton = new TermFactory();
                singleton.loadKnownTerms();
                initialized = true;
            }
        }
        return singleton;
    }

    private TermFactory() {
    }

    private void loadKnownTerms() {
        this.registerTermEnum(DwcTerm.class, new String[0]);
        this.registerTermEnum(DcTerm.class, "dct");
        this.registerTermEnum(GbifTerm.class, new String[0]);
        this.registerTermEnum(GbifInternalTerm.class, new String[0]);
        this.registerTermEnum(IucnTerm.class, new String[0]);
        this.registerTermEnum(DcElement.class, new String[0]);
        this.registerTermEnum(AcefTerm.class, new String[0]);
        this.registerTermEnum(AcTerm.class, new String[0]);
        this.registerTermEnum(XmpTerm.class, "adobe");
        this.registerTermEnum(XmpRightsTerm.class, "xmp", "adobe");
    }

    public Set<Class<? extends Enum>> listRegisteredTermEnums() {
        return Collections.unmodifiableSet(this.registeredEnumClasses);
    }

    public void registerTerm(Term term) {
        this.addTerm(term, new String[0]);
    }

    public void registerTerm(UnknownTerm term) {
        this.addTerm(term.qualifiedName(), term);
    }

    public <T extends Enum & AlternativeNames> void registerTermEnum(Class<T> termClass, String ... altPrefixes) {
        if (this.registeredEnumClasses.contains(termClass)) {
            LOG.debug("{} is already registered", termClass);
        } else {
            this.registeredEnumClasses.add(termClass);
            for (Enum term : (Enum[])termClass.getEnumConstants()) {
                this.addTerm((Term)((Object)term), altPrefixes);
                for (String alt : ((AlternativeNames)((Object)term)).alternativeNames()) {
                    this.addTerm(alt, (Term)((Object)term));
                    this.addTerm(((Term)((Object)term)).prefix() + ":" + alt, (Term)((Object)term));
                    this.addTerm(((Term)((Object)term)).namespace().resolve(alt).toString(), (Term)((Object)term));
                    for (String pre : altPrefixes) {
                        this.addTerm(pre + ":" + alt, (Term)((Object)term));
                    }
                }
            }
        }
    }

    private void addTerm(Term term, String ... altPrefixes) {
        this.addTerm(term.simpleName(), term);
        this.addTerm(term.prefixedName(), term);
        this.addTerm(term.qualifiedName(), term);
        for (String pre : altPrefixes) {
            this.addTerm(pre + ":" + term.simpleName(), term);
        }
    }

    private void addTerm(String key, Term term) {
        if (key == null || key.trim().isEmpty()) {
            return;
        }
        Map<String, Term> map = this.termMap(term.isClass());
        if (map.containsKey(key)) {
            Term t1 = map.get(key);
            if (!t1.equals(term)) {
                LOG.warn("{} terms {} and {} are both known as \"{}\". Keeping only earlier {}", new Object[]{term.isClass() ? "Class" : "Property", map.get(key), term, key, map.get(key)});
            }
        } else {
            map.put(key, term);
            key = TermFactory.normaliseTerm(key);
            if (!map.containsKey(key)) {
                map.put(key, term);
            }
        }
    }

    private Map<String, Term> termMap(boolean isClass) {
        return isClass ? this.classTerms : this.terms;
    }

    public static String normaliseTerm(String term) {
        String x = NON_ALPHA_NUM_PATTERN.matcher(term).replaceAll("");
        if ((x = x.replaceFirst("^https?", "")).isEmpty()) {
            return "";
        }
        return x.toLowerCase();
    }

    public Term findTerm(String termName) throws IllegalArgumentException {
        if (this.terms.containsKey(termName)) {
            return this.terms.get(termName);
        }
        Term t = this.findTermOnly(termName, true);
        if (t == null) {
            t = this.findTermOnly(termName, false);
        }
        if (t == null) {
            t = this.createUnknownTerm(termName, false);
        }
        return t;
    }

    public Term findPropertyTerm(String termName) throws IllegalArgumentException {
        return this.findTerm(termName, false);
    }

    public Term findClassTerm(String termName) throws IllegalArgumentException {
        return this.findTerm(termName, true);
    }

    public Term findTerm(String termName, boolean isClassTerm) throws IllegalArgumentException {
        if (termName == null || termName.trim().isEmpty()) {
            return null;
        }
        Term t = this.findTermOnly(termName, isClassTerm);
        if (t == null) {
            t = this.createUnknownTerm(termName, isClassTerm);
        }
        return t;
    }

    private Term findTermOnly(String termName, boolean isClassTerm) throws IllegalArgumentException {
        if (termName == null || termName.trim().isEmpty()) {
            return null;
        }
        Map<String, Term> map = this.termMap(isClassTerm);
        if (map.containsKey(termName)) {
            return map.get(termName);
        }
        if (map.containsKey(TermFactory.normaliseTerm(termName))) {
            return map.get(TermFactory.normaliseTerm(termName));
        }
        return null;
    }

    private Term createUnknownTerm(String termName, boolean isClassTerm) {
        UnknownTerm term = UnknownTerm.build(termName, isClassTerm);
        this.addTerm(termName, term);
        this.addTerm(term.qualifiedName(), term);
        return term;
    }

    static {
        initialized = false;
        LOCK = new Object();
    }
}

