/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.terms;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.gbif.dwc.terms.AlternativeNames;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;

public enum DwcTerm implements Term,
AlternativeNames,
Serializable
{
    Occurrence("Occurrence", "DarwinCore", "SimpleDarwinCore"),
    Organism("Organism", new String[0]),
    MaterialSample("MaterialSample", new String[0]),
    Event("Event", new String[0]),
    GeologicalContext("GeologicalContext", new String[0]),
    Identification("Identification", new String[0]),
    Taxon("Taxon", new String[0]),
    MeasurementOrFact("MeasurementOrFact", new String[0]),
    ResourceRelationship("ResourceRelationship", new String[0]),
    institutionID("Record", new String[0]),
    collectionID("Record", new String[0]),
    datasetID("Record", new String[0]),
    institutionCode("Record", new String[0]),
    collectionCode("Record", new String[0]),
    datasetName("Record", new String[0]),
    ownerInstitutionCode("Record", new String[0]),
    basisOfRecord("Record", new String[0]),
    informationWithheld("Record", new String[0]),
    dataGeneralizations("Record", new String[0]),
    dynamicProperties("Record", new String[0]),
    occurrenceID("Occurrence", new String[0]),
    catalogNumber("Occurrence", "catalogNumberNumeric"),
    recordNumber("Occurrence", "collectorNumber"),
    recordedBy("Occurrence", "collector"),
    individualCount("Occurrence", new String[0]),
    organismQuantity("Occurrence", new String[0]),
    organismQuantityType("Occurrence", new String[0]),
    sex("Occurrence", new String[0]),
    lifeStage("Occurrence", new String[0]),
    reproductiveCondition("Occurrence", new String[0]),
    behavior("Occurrence", new String[0]),
    establishmentMeans("Occurrence", new String[0]),
    occurrenceStatus("Occurrence", new String[0]),
    preparations("Occurrence", new String[0]),
    disposition("Occurrence", new String[0]),
    associatedMedia("Occurrence", new String[0]),
    associatedReferences("Occurrence", new String[0]),
    associatedSequences("Occurrence", new String[0]),
    associatedTaxa("Occurrence", new String[0]),
    otherCatalogNumbers("Occurrence", new String[0]),
    occurrenceRemarks("Occurrence", new String[0]),
    organismID("Organism", "individualID"),
    organismName("Organism", new String[0]),
    organismScope("Organism", new String[0]),
    associatedOccurrences("Organism", new String[0]),
    associatedOrganisms("Organism", new String[0]),
    previousIdentifications("Organism", new String[0]),
    organismRemarks("Organism", new String[0]),
    materialSampleID("MaterialSample", new String[0]),
    eventID("Event", new String[0]),
    parentEventID("Event", new String[0]),
    fieldNumber("Event", new String[0]),
    eventDate("Event", "earliestDateCollected", "latestDateCollected"),
    eventTime("Event", new String[0]),
    startDayOfYear("Event", new String[0]),
    endDayOfYear("Event", new String[0]),
    year("Event", new String[0]),
    month("Event", new String[0]),
    day("Event", new String[0]),
    verbatimEventDate("Event", new String[0]),
    habitat("Event", new String[0]),
    samplingProtocol("Event", new String[0]),
    samplingEffort("Event", new String[0]),
    sampleSizeValue("Event", new String[0]),
    sampleSizeUnit("Event", new String[0]),
    fieldNotes("Event", new String[0]),
    eventRemarks("Event", new String[0]),
    locationID("Location", new String[0]),
    higherGeographyID("Location", new String[0]),
    higherGeography("Location", new String[0]),
    continent("Location", new String[0]),
    waterBody("Location", new String[0]),
    islandGroup("Location", new String[0]),
    island("Location", new String[0]),
    country("Location", new String[0]),
    countryCode("Location", new String[0]),
    stateProvince("Location", "state", "province"),
    county("Location", new String[0]),
    municipality("Location", "city"),
    locality("Location", new String[0]),
    verbatimLocality("Location", new String[0]),
    minimumElevationInMeters("Location", new String[0]),
    maximumElevationInMeters("Location", new String[0]),
    verbatimElevation("Location", new String[0]),
    minimumDepthInMeters("Location", new String[0]),
    maximumDepthInMeters("Location", new String[0]),
    verbatimDepth("Location", new String[0]),
    minimumDistanceAboveSurfaceInMeters("Location", new String[0]),
    maximumDistanceAboveSurfaceInMeters("Location", new String[0]),
    locationAccordingTo("Location", new String[0]),
    locationRemarks("Location", new String[0]),
    decimalLatitude("Location", "latitude"),
    decimalLongitude("Location", "longitude"),
    geodeticDatum("Location", "datum", "horizontaldatum"),
    coordinateUncertaintyInMeters("Location", new String[0]),
    coordinatePrecision("Location", new String[0]),
    pointRadiusSpatialFit("Location", new String[0]),
    verbatimCoordinates("Location", new String[0]),
    verbatimLatitude("Location", new String[0]),
    verbatimLongitude("Location", new String[0]),
    verbatimCoordinateSystem("Location", new String[0]),
    verbatimSRS("Location", new String[0]),
    footprintWKT("Location", new String[0]),
    footprintSRS("Location", new String[0]),
    footprintSpatialFit("Location", new String[0]),
    georeferencedBy("Location", new String[0]),
    georeferencedDate("Location", new String[0]),
    georeferenceProtocol("Location", new String[0]),
    georeferenceSources("Location", new String[0]),
    georeferenceVerificationStatus("Location", new String[0]),
    georeferenceRemarks("Location", new String[0]),
    geologicalContextID("GeologicalContext", new String[0]),
    earliestEonOrLowestEonothem("GeologicalContext", new String[0]),
    latestEonOrHighestEonothem("GeologicalContext", new String[0]),
    earliestEraOrLowestErathem("GeologicalContext", new String[0]),
    latestEraOrHighestErathem("GeologicalContext", new String[0]),
    earliestPeriodOrLowestSystem("GeologicalContext", new String[0]),
    latestPeriodOrHighestSystem("GeologicalContext", new String[0]),
    earliestEpochOrLowestSeries("GeologicalContext", new String[0]),
    latestEpochOrHighestSeries("GeologicalContext", new String[0]),
    earliestAgeOrLowestStage("GeologicalContext", new String[0]),
    latestAgeOrHighestStage("GeologicalContext", new String[0]),
    lowestBiostratigraphicZone("GeologicalContext", new String[0]),
    highestBiostratigraphicZone("GeologicalContext", new String[0]),
    lithostratigraphicTerms("GeologicalContext", new String[0]),
    group("GeologicalContext", new String[0]),
    formation("GeologicalContext", new String[0]),
    member("GeologicalContext", new String[0]),
    bed("GeologicalContext", new String[0]),
    identificationID("Identification", new String[0]),
    identificationQualifier("Identification", new String[0]),
    typeStatus("Identification", new String[0]),
    identifiedBy("Identification", new String[0]),
    dateIdentified("Identification", new String[0]),
    identificationReferences("Identification", new String[0]),
    identificationVerificationStatus("Identification", new String[0]),
    identificationRemarks("Identification", new String[0]),
    taxonID("Taxon", "nameUsageID"),
    scientificNameID("Taxon", "nameID"),
    acceptedNameUsageID("Taxon", "acceptedTaxonID"),
    parentNameUsageID("Taxon", "higherNameUsageID", "parentTaxonID"),
    originalNameUsageID("Taxon", "originalNameID", "basionymID"),
    nameAccordingToID("Taxon", "taxonAccordingToID"),
    namePublishedInID("Taxon", new String[0]),
    taxonConceptID("Taxon", new String[0]),
    scientificName("Taxon", new String[0]),
    acceptedNameUsage("Taxon", "acceptedTaxon"),
    parentNameUsage("Taxon", "parentTaxon", "higherTaxon", "higherNameUsage"),
    originalNameUsage("Taxon", "originalName", "originalTaxon", "basionym"),
    nameAccordingTo("Taxon", "taxonAccordingTo"),
    namePublishedIn("Taxon", new String[0]),
    namePublishedInYear("Taxon", new String[0]),
    higherClassification("Taxon", new String[0]),
    kingdom("Taxon", new String[0]),
    phylum("Taxon", new String[0]),
    class_("Taxon", "class"),
    order("Taxon", new String[0]),
    family("Taxon", new String[0]),
    genus("Taxon", new String[0]),
    subgenus("Taxon", new String[0]),
    specificEpithet("Taxon", new String[0]),
    infraspecificEpithet("Taxon", new String[0]),
    taxonRank("Taxon", "rank"),
    verbatimTaxonRank("Taxon", new String[0]),
    scientificNameAuthorship("Taxon", new String[0]),
    vernacularName("Taxon", new String[0]),
    nomenclaturalCode("Taxon", new String[0]),
    taxonomicStatus("Taxon", new String[0]),
    nomenclaturalStatus("Taxon", new String[0]),
    taxonRemarks("Taxon", "taxonRemark"),
    measurementID("MeasurementOrFact", new String[0]),
    measurementType("MeasurementOrFact", new String[0]),
    measurementValue("MeasurementOrFact", new String[0]),
    measurementAccuracy("MeasurementOrFact", new String[0]),
    measurementUnit("MeasurementOrFact", new String[0]),
    measurementDeterminedBy("MeasurementOrFact", new String[0]),
    measurementDeterminedDate("MeasurementOrFact", new String[0]),
    measurementMethod("MeasurementOrFact", new String[0]),
    measurementRemarks("MeasurementOrFact", new String[0]),
    resourceRelationshipID("ResourceRelationship", new String[0]),
    resourceID("ResourceRelationship", new String[0]),
    relatedResourceID("ResourceRelationship", new String[0]),
    relationshipOfResource("ResourceRelationship", new String[0]),
    relationshipAccordingTo("ResourceRelationship", new String[0]),
    relationshipEstablishedDate("ResourceRelationship", new String[0]),
    relationshipRemarks("ResourceRelationship", new String[0]);

    private static final String PREFIX = "dwc";
    private static final String NS = "http://rs.tdwg.org/dwc/terms/";
    private static final URI NS_URI;
    public static final String GROUP_RECORD = "Record";
    public static final String GROUP_OCCURRENCE = "Occurrence";
    public static final String GROUP_ORGANISM = "Organism";
    public static final String GROUP_MATERIAL_SAMPLE = "MaterialSample";
    public static final String GROUP_EVENT = "Event";
    public static final String GROUP_LOCATION = "Location";
    public static final String GROUP_GEOLOGICALCONTEXT = "GeologicalContext";
    public static final String GROUP_IDENTIFICATION = "Identification";
    public static final String GROUP_TAXON = "Taxon";
    public static final String GROUP_MEASUREMENTORFACT = "MeasurementOrFact";
    public static final String GROUP_RESOURCERELATIONSHIP = "ResourceRelationship";
    public static final String[] GROUPS;
    public static final DwcTerm[] TAXONOMIC_TERMS;
    public static final DwcTerm[] HIGHER_RANKS;
    public static final DwcTerm[] CLASS_TERMS;
    private final String groupName;
    public final String normQName = TermFactory.normaliseTerm(this.qualifiedName());
    public final String[] normAlts;

    private DwcTerm(String groupName, String ... alternatives) {
        for (int i = 0; i < alternatives.length; ++i) {
            alternatives[i] = TermFactory.normaliseTerm(alternatives[i]);
        }
        this.normAlts = alternatives;
        this.groupName = groupName;
    }

    @Override
    public String simpleName() {
        if (this == class_) {
            return "class";
        }
        return this.name();
    }

    @Override
    public String[] alternativeNames() {
        return this.normAlts;
    }

    public String getGroup() {
        return this.groupName;
    }

    @Override
    public boolean isClass() {
        return Character.isUpperCase(this.simpleName().charAt(0));
    }

    public static List<DwcTerm> listByGroup(String group) {
        ArrayList<DwcTerm> terms = new ArrayList<DwcTerm>();
        for (DwcTerm t : DwcTerm.values()) {
            if (!t.getGroup().equalsIgnoreCase(group)) continue;
            terms.add(t);
        }
        return terms;
    }

    @Override
    public String prefix() {
        return PREFIX;
    }

    @Override
    public URI namespace() {
        return NS_URI;
    }

    public String toString() {
        return this.prefixedName();
    }

    static {
        NS_URI = URI.create(NS);
        GROUPS = new String[]{GROUP_RECORD, GROUP_OCCURRENCE, GROUP_ORGANISM, GROUP_EVENT, GROUP_LOCATION, GROUP_GEOLOGICALCONTEXT, GROUP_IDENTIFICATION, GROUP_TAXON, GROUP_MEASUREMENTORFACT, GROUP_RESOURCERELATIONSHIP};
        TAXONOMIC_TERMS = new DwcTerm[]{taxonID, scientificNameID, acceptedNameUsageID, parentNameUsageID, originalNameUsageID, nameAccordingToID, namePublishedInID, taxonConceptID, scientificName, acceptedNameUsage, parentNameUsage, originalNameUsage, nameAccordingTo, namePublishedIn, namePublishedInYear, higherClassification, kingdom, phylum, class_, order, family, genus, subgenus, specificEpithet, infraspecificEpithet, taxonRank, verbatimTaxonRank, scientificNameAuthorship, vernacularName, nomenclaturalCode, taxonomicStatus, nomenclaturalStatus, taxonRemarks};
        HIGHER_RANKS = new DwcTerm[]{kingdom, phylum, class_, order, family, genus, subgenus};
        CLASS_TERMS = new DwcTerm[]{Occurrence, Organism, MaterialSample, Event, GeologicalContext, Identification, Taxon, MeasurementOrFact, ResourceRelationship};
    }
}

