/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.lucene.util.Version;
import org.apache.solr.api.V2HttpCall;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.metrics.AltBufferPoolMetricSet;
import org.apache.solr.metrics.OperatingSystemMetricSet;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.servlet.BaseSolrFilter;
import org.apache.solr.servlet.HttpSolrCall;
import org.apache.solr.servlet.ServletInputStreamWrapper;
import org.apache.solr.servlet.ServletOutputStreamWrapper;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.StartupLoggingUtils;
import org.apache.solr.util.SolrFileCleaningTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDispatchFilter
extends BaseSolrFilter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected volatile CoreContainer cores;
    protected final CountDownLatch init = new CountDownLatch(1);
    protected String abortErrorMessage = null;
    protected HttpClient httpClient;
    private ArrayList<Pattern> excludePatterns;
    private Boolean testMode = null;
    private boolean isV2Enabled;
    public static final String PROPERTIES_ATTRIBUTE = "solr.properties";
    public static final String SOLRHOME_ATTRIBUTE = "solr.solr.home";
    public static final String SOLR_LOG_MUTECONSOLE = "solr.log.muteconsole";
    public static final String SOLR_LOG_LEVEL = "solr.log.level";

    public SolrDispatchFilter() {
        String tm;
        boolean bl = this.isV2Enabled = !"true".equals(System.getProperty("disable.v2.api", "false"));
        assert ((this.testMode = Boolean.valueOf(true)).booleanValue());
        this.testMode = this.testMode == null ? Boolean.valueOf(false) : ((tm = System.getProperty("solr.tests.doContainerStreamCloseAssert")) != null ? Boolean.valueOf(Boolean.parseBoolean(tm)) : Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig config) throws ServletException {
        log.trace("SolrDispatchFilter.init(): {}", (Object)this.getClass().getClassLoader());
        CoreContainer coresInit = null;
        try {
            String exclude;
            String logLevel;
            SolrRequestParsers.fileCleaningTracker = new SolrFileCleaningTracker();
            StartupLoggingUtils.checkLogDir();
            this.logWelcomeBanner();
            String muteConsole = System.getProperty(SOLR_LOG_MUTECONSOLE);
            if (muteConsole != null && !Arrays.asList("false", "0", "off", "no").contains(muteConsole.toLowerCase(Locale.ROOT))) {
                StartupLoggingUtils.muteConsole();
            }
            if ((logLevel = System.getProperty(SOLR_LOG_LEVEL)) != null) {
                StartupLoggingUtils.changeLogLevel(logLevel);
            }
            if ((exclude = config.getInitParameter("excludePatterns")) != null) {
                String[] excludeArray = exclude.split(",");
                this.excludePatterns = new ArrayList();
                for (String element : excludeArray) {
                    this.excludePatterns.add(Pattern.compile(element));
                }
            }
            try {
                Properties extraProperties = (Properties)config.getServletContext().getAttribute(PROPERTIES_ATTRIBUTE);
                if (extraProperties == null) {
                    extraProperties = new Properties();
                }
                String solrHome = (String)config.getServletContext().getAttribute(SOLRHOME_ATTRIBUTE);
                ExecutorUtil.addThreadLocalProvider((ExecutorUtil.InheritableThreadLocalProvider)SolrRequestInfo.getInheritableThreadLocalProvider());
                coresInit = this.createCoreContainer(solrHome == null ? SolrResourceLoader.locateSolrHome() : Paths.get(solrHome, new String[0]), extraProperties);
                this.httpClient = coresInit.getUpdateShardHandler().getHttpClient();
                this.setupJvmMetrics(coresInit);
                log.debug("user.dir=" + System.getProperty("user.dir"));
            }
            catch (Throwable t) {
                log.error("Could not start Solr. Check solr/home property and the logs");
                SolrCore.log(t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
            }
        }
        finally {
            log.trace("SolrDispatchFilter.init() done");
            this.cores = coresInit;
            this.init.countDown();
        }
    }

    private void setupJvmMetrics(CoreContainer coresInit) {
        SolrMetricManager metricManager = coresInit.getMetricManager();
        try {
            String registry = SolrMetricManager.getRegistryName(SolrInfoMBean.Group.jvm, new String[0]);
            metricManager.registerAll(registry, new AltBufferPoolMetricSet(), true, "buffers");
            metricManager.registerAll(registry, (MetricSet)new ClassLoadingGaugeSet(), true, "classes");
            metricManager.registerAll(registry, new OperatingSystemMetricSet(), true, "os");
            metricManager.registerAll(registry, (MetricSet)new GarbageCollectorMetricSet(), true, "gc");
            metricManager.registerAll(registry, (MetricSet)new MemoryUsageGaugeSet(), true, "memory");
            metricManager.registerAll(registry, (MetricSet)new ThreadStatesGaugeSet(), true, "threads");
        }
        catch (Exception e) {
            log.warn("Error registering JVM metrics", (Throwable)e);
        }
    }

    private void logWelcomeBanner() {
        log.info(" ___      _       Welcome to Apache Solr\u2122 version {}", (Object)this.solrVersion());
        log.info("/ __| ___| |_ _   Starting in {} mode on port {}", (Object)(this.isCloudMode() ? "cloud" : "standalone"), (Object)this.getSolrPort());
        log.info("\\__ \\/ _ \\ | '_|  Install dir: {}", (Object)System.getProperty("solr.install.dir"));
        log.info("|___/\\___/_|_|    Start time: {}", (Object)Instant.now().toString());
    }

    private String solrVersion() {
        String specVer = Version.LATEST.toString();
        try {
            String implVer = SolrCore.class.getPackage().getImplementationVersion();
            return specVer.equals(implVer.split(" ")[0]) ? specVer : implVer;
        }
        catch (Exception e) {
            return specVer;
        }
    }

    private String getSolrPort() {
        return System.getProperty("jetty.port");
    }

    private boolean isCloudMode() {
        return System.getProperty("zkHost") != null && !StringUtils.isEmpty((String)System.getProperty("zkHost")) || System.getProperty("zkRun") != null;
    }

    protected CoreContainer createCoreContainer(Path solrHome, Properties extraProperties) {
        NodeConfig nodeConfig = SolrDispatchFilter.loadNodeConfig(solrHome, extraProperties);
        CoreContainer coreContainer = new CoreContainer(nodeConfig, extraProperties, true);
        coreContainer.load();
        return coreContainer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeConfig loadNodeConfig(Path solrHome, Properties nodeProperties) {
        String zkHost;
        SolrResourceLoader loader = new SolrResourceLoader(solrHome, null, nodeProperties);
        if (!StringUtils.isEmpty((String)System.getProperty("solr.solrxml.location"))) {
            log.warn("Solr property solr.solrxml.location is no longer supported. Will automatically load solr.xml from ZooKeeper if it exists");
        }
        if (StringUtils.isEmpty((String)(zkHost = System.getProperty("zkHost")))) return SolrXmlConfig.fromSolrHome(loader, loader.getInstancePath());
        try (SolrZkClient zkClient = new SolrZkClient(zkHost, 30000);){
            if (zkClient.exists("/solr.xml", true).booleanValue()) {
                log.info("solr.xml found in ZooKeeper. Loading...");
                byte[] data = zkClient.getData("/solr.xml", null, null, true);
                NodeConfig nodeConfig = SolrXmlConfig.fromInputStream(loader, new ByteArrayInputStream(data));
                return nodeConfig;
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error occurred while loading solr.xml from zookeeper", (Throwable)e);
        }
        log.info("Loading solr.xml from SolrHome (not found in ZooKeeper)");
        return SolrXmlConfig.fromSolrHome(loader, loader.getInstancePath());
    }

    public CoreContainer getCores() {
        return this.cores;
    }

    public void destroy() {
        try {
            SolrFileCleaningTracker fileCleaningTracker = SolrRequestParsers.fileCleaningTracker;
            if (fileCleaningTracker != null) {
                fileCleaningTracker.exitWhenFinished();
            }
        }
        catch (Exception e) {
            log.warn("Exception closing FileCleaningTracker", (Throwable)e);
        }
        finally {
            SolrRequestParsers.fileCleaningTracker = null;
        }
        if (this.cores != null) {
            try {
                this.cores.shutdown();
            }
            finally {
                this.cores = null;
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter(request, response, chain, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, boolean retry) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            return;
        }
        try {
            AtomicReference<ServletRequest> wrappedRequest;
            if (this.cores == null || this.cores.isShutDown()) {
                try {
                    this.init.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String msg = "Error processing the request. CoreContainer is either not initialized or shutting down.";
                if (this.cores == null || this.cores.isShutDown()) {
                    log.error("Error processing the request. CoreContainer is either not initialized or shutting down.");
                    throw new UnavailableException("Error processing the request. CoreContainer is either not initialized or shutting down.");
                }
            }
            if (!this.authenticateRequest(request, response, wrappedRequest = new AtomicReference<ServletRequest>())) {
                return;
            }
            if (wrappedRequest.get() != null) {
                request = wrappedRequest.get();
            }
            request = this.closeShield(request, retry);
            response = this.closeShield(response, retry);
            if (this.cores.getAuthenticationPlugin() != null) {
                log.debug("User principal: {}", (Object)((HttpServletRequest)request).getUserPrincipal());
            }
            if (this.excludePatterns != null) {
                String requestPath = ((HttpServletRequest)request).getServletPath();
                String extraPath = ((HttpServletRequest)request).getPathInfo();
                if (extraPath != null) {
                    requestPath = requestPath + extraPath;
                }
                for (Pattern p : this.excludePatterns) {
                    Matcher matcher = p.matcher(requestPath);
                    if (!matcher.lookingAt()) continue;
                    chain.doFilter(request, response);
                    return;
                }
            }
            HttpSolrCall call = this.getHttpSolrCall((HttpServletRequest)request, (HttpServletResponse)response, retry);
            ExecutorUtil.setServerThreadFlag((Boolean)Boolean.TRUE);
            try {
                Action result = call.call();
                switch (result) {
                    case PASSTHROUGH: {
                        chain.doFilter(request, response);
                        return;
                    }
                    case RETRY: {
                        this.doFilter(request, response, chain, true);
                        return;
                    }
                    case FORWARD: {
                        request.getRequestDispatcher(call.getPath()).forward(request, response);
                        return;
                    }
                }
                return;
            }
            finally {
                call.destroy();
                ExecutorUtil.setServerThreadFlag(null);
            }
        }
        finally {
            this.consumeInputFully((HttpServletRequest)request);
        }
    }

    private void consumeInputFully(HttpServletRequest req) {
        try {
            ServletInputStream is = req.getInputStream();
            while (!is.isFinished() && is.read() != -1) {
            }
        }
        catch (IOException e) {
            log.info("Could not consume full client request", (Throwable)e);
        }
    }

    protected HttpSolrCall getHttpSolrCall(HttpServletRequest request, HttpServletResponse response, boolean retry) {
        String path = request.getServletPath();
        if (request.getPathInfo() != null) {
            path = path + request.getPathInfo();
        }
        if (this.isV2Enabled && (path.startsWith("/____v2/") || path.equals("/____v2"))) {
            return new V2HttpCall(this, this.cores, request, response, false);
        }
        return new HttpSolrCall(this, this.cores, request, response, retry);
    }

    private boolean authenticateRequest(ServletRequest request, ServletResponse response, AtomicReference<ServletRequest> wrappedRequest) throws IOException {
        boolean requestContinues = false;
        AtomicBoolean isAuthenticated = new AtomicBoolean(false);
        AuthenticationPlugin authenticationPlugin = this.cores.getAuthenticationPlugin();
        if (authenticationPlugin == null) {
            return true;
        }
        if ("/admin/info/key".equals(((HttpServletRequest)request).getServletPath()) || "/admin/info/key".equals(((HttpServletRequest)request).getPathInfo())) {
            return true;
        }
        String header = ((HttpServletRequest)request).getHeader("SolrAuth");
        if (header != null && this.cores.getPkiAuthenticationPlugin() != null) {
            authenticationPlugin = this.cores.getPkiAuthenticationPlugin();
        }
        try {
            log.debug("Request to authenticate: {}, domain: {}, port: {}", new Object[]{request, request.getLocalName(), request.getLocalPort()});
            requestContinues = authenticationPlugin.doAuthenticate(request, response, (req, rsp) -> {
                isAuthenticated.set(true);
                wrappedRequest.set(req);
            });
        }
        catch (Exception e) {
            log.info("Error authenticating", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error during request authentication, ", (Throwable)e);
        }
        if (!requestContinues || !isAuthenticated.get()) {
            response.flushBuffer();
            return false;
        }
        return true;
    }

    private ServletRequest closeShield(ServletRequest request, boolean retry) {
        if (this.testMode.booleanValue() && !retry) {
            return new HttpServletRequestWrapper((HttpServletRequest)request){
                ServletInputStream stream;

                public ServletInputStream getInputStream() throws IOException {
                    if (this.stream == null) {
                        this.stream = new ServletInputStreamWrapper(super.getInputStream()){

                            @Override
                            public void close() {
                                assert (false) : "Attempted close of request input stream.";
                            }
                        };
                    }
                    return this.stream;
                }
            };
        }
        return request;
    }

    private ServletResponse closeShield(ServletResponse response, boolean retry) {
        if (this.testMode.booleanValue() && !retry) {
            return new HttpServletResponseWrapper((HttpServletResponse)response){
                ServletOutputStream stream;

                public ServletOutputStream getOutputStream() throws IOException {
                    if (this.stream == null) {
                        this.stream = new ServletOutputStreamWrapper(super.getOutputStream()){

                            @Override
                            public void close() {
                                assert (false) : "Attempted close of response output stream.";
                            }
                        };
                    }
                    return this.stream;
                }
            };
        }
        return response;
    }

    public static enum Action {
        PASSTHROUGH,
        FORWARD,
        RETURN,
        RETRY,
        ADMIN,
        REMOTEQUERY,
        PROCESS;

    }
}

