/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.SubQueryAugmenter;
import org.apache.solr.response.transform.TransformerFactory;

public class SubQueryAugmenterFactory
extends TransformerFactory {
    @Override
    public DocTransformer create(String field, SolrParams params, SolrQueryRequest req) {
        if (field.contains("[") || field.contains("]")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "please give an exlicit name for [subquery] column ie fl=relation:[subquery ..]");
        }
        this.checkThereIsNoDupe(field, req.getContext());
        String fromIndex = params.get("fromIndex");
        EmbeddedSolrServer solrClient = new EmbeddedSolrServer(req.getCore());
        SolrParams subParams = this.retainAndShiftPrefix(req.getParams(), field + ".");
        return new SubQueryAugmenter(solrClient, fromIndex, field, field, subParams, params.get("separator", ","));
    }

    private void checkThereIsNoDupe(String field, Map<Object, Object> context) {
        Map<String, Boolean> conflictMap;
        String conflictMapKey = this.getClass().getSimpleName();
        if (context.containsKey(conflictMapKey)) {
            conflictMap = (Map)context.get(conflictMapKey);
        } else {
            conflictMap = new HashMap();
            context.put(conflictMapKey, conflictMap);
        }
        if (conflictMap.containsKey(field)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "[subquery] name " + field + " is duplicated");
        }
        conflictMap.put(field, true);
    }

    private SolrParams retainAndShiftPrefix(SolrParams params, String subPrefix) {
        ModifiableSolrParams out = new ModifiableSolrParams();
        Iterator baseKeyIt = params.getParameterNamesIterator();
        while (baseKeyIt.hasNext()) {
            String key = (String)baseKeyIt.next();
            if (!key.startsWith(subPrefix)) continue;
            out.set(key.substring(subPrefix.length()), params.getParams(key));
        }
        return out;
    }
}

