/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.params.TermsParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.BoundedTreeSet;

public class TermsComponent
extends SearchComponent {
    public static final int UNLIMITED_MAX_COUNT = -1;
    public static final String COMPONENT_NAME = "terms";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.get(COMPONENT_NAME, "false").equals("true")) {
            return;
        }
        rb.doTerms = true;
        String shards = params.get("shards");
        if (shards != null) {
            rb.isDistrib = true;
            if (params.get("shards.qt") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shards.qt parameter specified");
            }
            List lst = StrUtils.splitSmart((String)shards, (String)",", (boolean)true);
            rb.shards = lst.toArray(new String[lst.size()]);
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        String termList;
        SolrParams params = rb.req.getParams();
        if (!params.get(COMPONENT_NAME, "false").equals("true")) {
            return;
        }
        String[] fields = params.getParams("terms.fl");
        SimpleOrderedMap termsResult = new SimpleOrderedMap();
        rb.rsp.add(COMPONENT_NAME, termsResult);
        if (fields == null || fields.length == 0) {
            return;
        }
        boolean termStats = params.getBool("terms.stats", false);
        if (termStats) {
            SimpleOrderedMap stats = new SimpleOrderedMap();
            rb.rsp.add("indexstats", stats);
            TermsComponent.collectStats(rb.req.getSearcher(), (NamedList<Number>)stats);
        }
        if ((termList = params.get("terms.list")) != null) {
            boolean includeTotalTermFreq = params.getBool("terms.ttf", false);
            TermsComponent.fetchTerms(rb.req.getSearcher(), fields, termList, includeTotalTermFreq, (NamedList<Object>)termsResult);
            return;
        }
        int limit = params.getInt("terms.limit", 10);
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        String lowerStr = params.get("terms.lower");
        String upperStr = params.get("terms.upper");
        boolean upperIncl = params.getBool("terms.upper.incl", false);
        boolean lowerIncl = params.getBool("terms.lower.incl", true);
        boolean sort = !"index".equals(params.get("terms.sort", "count"));
        int freqmin = params.getInt("terms.mincount", 1);
        int freqmax = params.getInt("terms.maxcount", -1);
        if (freqmax < 0) {
            freqmax = Integer.MAX_VALUE;
        }
        String prefix = params.get("terms.prefix");
        String regexp = params.get("terms.regex");
        Pattern pattern = regexp != null ? Pattern.compile(regexp, this.resolveRegexpFlags(params)) : null;
        boolean raw = params.getBool("terms.raw", false);
        LeafReader indexReader = rb.req.getSearcher().getSlowAtomicReader();
        Fields lfields = indexReader.fields();
        block0: for (String field : fields) {
            BytesRef lowerBytes;
            FieldType ft;
            NamedList fieldTerms = new NamedList();
            termsResult.add(field, (Object)fieldTerms);
            Terms terms = lfields.terms(field);
            if (terms == null) continue;
            FieldType fieldType = ft = raw ? null : rb.req.getSchema().getFieldTypeNoEx(field);
            if (ft == null) {
                ft = new StrField();
            }
            BytesRef prefixBytes = prefix == null ? null : new BytesRef((CharSequence)prefix);
            BytesRef upperBytes = null;
            if (upperStr != null) {
                BytesRefBuilder b = new BytesRefBuilder();
                ft.readableToIndexed(upperStr, b);
                upperBytes = b.get();
            }
            if (lowerStr == null) {
                lowerBytes = prefixBytes;
            } else {
                lowerBytes = new BytesRef();
                if (raw) {
                    lowerBytes = new BytesRef((CharSequence)lowerStr);
                } else {
                    BytesRefBuilder b = new BytesRefBuilder();
                    ft.readableToIndexed(lowerStr, b);
                    lowerBytes = b.get();
                }
            }
            TermsEnum termsEnum = terms.iterator();
            BytesRef term = null;
            if (lowerBytes != null) {
                if (termsEnum.seekCeil(lowerBytes) == TermsEnum.SeekStatus.END) {
                    termsEnum = null;
                } else {
                    term = termsEnum.term();
                    if (!lowerIncl && term.equals((Object)lowerBytes)) {
                        term = termsEnum.next();
                    }
                }
            } else {
                term = termsEnum.next();
            }
            int i = 0;
            BoundedTreeSet<SimpleFacets.CountPair<BytesRef, Integer>> queue = sort ? new BoundedTreeSet<SimpleFacets.CountPair<BytesRef, Integer>>(limit) : null;
            CharsRefBuilder external = new CharsRefBuilder();
            while (term != null && (i < limit || sort)) {
                int n;
                boolean externalized = false;
                if (prefixBytes != null && !StringHelper.startsWith((BytesRef)term, (BytesRef)prefixBytes)) break;
                if (pattern != null) {
                    ft.indexedToReadable(term, external);
                    externalized = true;
                    if (!pattern.matcher((CharSequence)external.get()).matches()) {
                        term = termsEnum.next();
                        continue;
                    }
                }
                if (upperBytes != null && ((n = term.compareTo(upperBytes)) > 0 || n == 0 && !upperIncl)) break;
                n = termsEnum.docFreq();
                if (n >= freqmin && n <= freqmax) {
                    if (sort) {
                        queue.add(new SimpleFacets.CountPair<BytesRef, Integer>(BytesRef.deepCopyOf((BytesRef)term), n));
                    } else {
                        if (!externalized) {
                            ft.indexedToReadable(term, external);
                        }
                        fieldTerms.add(external.toString(), (Object)n);
                        ++i;
                    }
                }
                term = termsEnum.next();
            }
            if (!sort) continue;
            for (SimpleFacets.CountPair countPair : queue) {
                if (i >= limit) continue block0;
                ft.indexedToReadable((BytesRef)countPair.key, external);
                fieldTerms.add(external.toString(), countPair.val);
                ++i;
            }
        }
    }

    int resolveRegexpFlags(SolrParams params) {
        String[] flagParams = params.getParams("terms.regex.flag");
        if (flagParams == null) {
            return 0;
        }
        int flags = 0;
        for (String flagParam : flagParams) {
            try {
                flags |= TermsParams.TermsRegexpFlag.valueOf((String)flagParam.toUpperCase(Locale.ROOT)).getValue();
            }
            catch (IllegalArgumentException iae) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown terms regex flag '" + flagParam + "'");
            }
        }
        return flags;
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (!rb.doTerms) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            TermsHelper th = rb._termsHelper;
            if (th == null) {
                th = rb._termsHelper = new TermsHelper();
                th.init(rb.req.getParams());
            }
            ShardRequest sreq = TermsComponent.createShardQuery(rb.req.getParams());
            rb.addRequest(this, sreq);
        }
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doTerms || (sreq.purpose & 0x400) == 0) {
            return;
        }
        TermsHelper th = rb._termsHelper;
        if (th != null) {
            for (ShardResponse srsp : sreq.responses) {
                NamedList terms = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
                th.parse((NamedList<NamedList<Object>>)terms);
                NamedList stats = (NamedList)srsp.getSolrResponse().getResponse().get("indexstats");
                if (stats == null) continue;
                th.numDocs += ((Number)stats.get("numDocs")).longValue();
                th.stats = true;
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doTerms || rb.stage != ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return;
        }
        TermsHelper ti = rb._termsHelper;
        NamedList<Object> terms = ti.buildResponse();
        rb.rsp.add(COMPONENT_NAME, terms);
        if (ti.stats) {
            SimpleOrderedMap stats = new SimpleOrderedMap();
            stats.add("numDocs", (Object)ti.numDocs);
            rb.rsp.add("indexstats", stats);
        }
        rb._termsHelper = null;
    }

    private static ShardRequest createShardQuery(SolrParams params) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1024;
        sreq.params = new ModifiableSolrParams(params);
        sreq.params.remove("terms.maxcount");
        sreq.params.remove("terms.mincount");
        sreq.params.set("terms.limit", -1);
        sreq.params.set("terms.sort", new String[]{"index"});
        return sreq;
    }

    private static void fetchTerms(SolrIndexSearcher indexSearcher, String[] fields, String termList, boolean includeTotalTermFreq, NamedList<Object> result) throws IOException {
        Object[] splitTerms = termList.split(",");
        for (int i = 0; i < splitTerms.length; ++i) {
            splitTerms[i] = ((String)splitTerms[i]).trim();
        }
        Arrays.sort(splitTerms);
        IndexReaderContext topReaderContext = indexSearcher.getTopReaderContext();
        for (String field : fields) {
            FieldType fieldType = indexSearcher.getSchema().getField(field).getType();
            Term[] terms = new Term[splitTerms.length];
            for (int i = 0; i < splitTerms.length; ++i) {
                terms[i] = new Term(field, fieldType.readableToIndexed((String)splitTerms[i]));
            }
            TermContext[] termContexts = new TermContext[terms.length];
            TermsComponent.collectTermContext(topReaderContext, termContexts, terms);
            SimpleOrderedMap termsMap = new SimpleOrderedMap();
            for (int i = 0; i < terms.length; ++i) {
                if (termContexts[i] == null) continue;
                String outTerm = fieldType.indexedToReadable(terms[i].bytes().utf8ToString());
                int docFreq = termContexts[i].docFreq();
                if (!includeTotalTermFreq) {
                    termsMap.add(outTerm, (Object)docFreq);
                    continue;
                }
                long totalTermFreq = termContexts[i].totalTermFreq();
                SimpleOrderedMap termStats = new SimpleOrderedMap();
                termStats.add("df", (Object)docFreq);
                termStats.add("ttf", (Object)totalTermFreq);
                termsMap.add(outTerm, (Object)termStats);
            }
            result.add(field, (Object)termsMap);
        }
    }

    private static void collectTermContext(IndexReaderContext topReaderContext, TermContext[] contextArray, Term[] queryTerms) throws IOException {
        TermsEnum termsEnum = null;
        for (LeafReaderContext context : topReaderContext.leaves()) {
            Fields fields = context.reader().fields();
            for (int i = 0; i < queryTerms.length; ++i) {
                Term term = queryTerms[i];
                Terms terms = fields.terms(term.field());
                if (terms == null) continue;
                termsEnum = terms.iterator();
                assert (termsEnum != null);
                if (termsEnum == TermsEnum.EMPTY) continue;
                TermContext termContext = contextArray[i];
                if (!termsEnum.seekExact(term.bytes())) continue;
                if (termContext == null) {
                    contextArray[i] = termContext = new TermContext(topReaderContext);
                }
                termContext.accumulateStatistics(termsEnum.docFreq(), termsEnum.totalTermFreq());
            }
        }
    }

    private static void collectStats(SolrIndexSearcher searcher, NamedList<Number> stats) {
        int numDocs = searcher.getTopReaderContext().reader().numDocs();
        stats.add("numDocs", (Object)numDocs);
    }

    @Override
    public String getDescription() {
        return "A Component for working with Term Enumerators";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.QUERY;
    }

    public static class TermsHelper {
        private HashMap<String, HashMap<String, TermsResponse.Term>> fieldmap = new HashMap(5);
        private SolrParams params;
        public long numDocs = 0L;
        public boolean stats;

        public void init(SolrParams params) {
            this.params = params;
            String[] fields = params.getParams("terms.fl");
            if (fields != null) {
                for (String field : fields) {
                    this.fieldmap.put(field, new HashMap(128));
                }
            }
        }

        public void parse(NamedList<NamedList<Object>> terms) {
            if (terms == null) {
                return;
            }
            TermsResponse termsResponse = new TermsResponse(terms);
            for (String key : this.fieldmap.keySet()) {
                HashMap<String, TermsResponse.Term> termmap = this.fieldmap.get(key);
                List termlist = termsResponse.getTerms(key);
                if (termlist == null) continue;
                for (TermsResponse.Term tc : termlist) {
                    String term = tc.getTerm();
                    if (termmap.containsKey(term)) {
                        TermsResponse.Term oldtc = termmap.get(term);
                        oldtc.addFrequency(tc.getFrequency());
                        oldtc.addTotalTermFreq(tc.getTotalTermFreq());
                        termmap.put(term, oldtc);
                        continue;
                    }
                    termmap.put(term, tc);
                }
            }
        }

        public NamedList<Object> buildResponse() {
            boolean sort;
            SimpleOrderedMap response = new SimpleOrderedMap();
            boolean bl = sort = !"index".equals(this.params.get("terms.sort", "count"));
            if (this.params.get("terms.list") != null) {
                sort = false;
            }
            long freqmin = 1L;
            String s = this.params.get("terms.mincount");
            if (s != null) {
                freqmin = Long.parseLong(s);
            }
            long freqmax = -1L;
            s = this.params.get("terms.maxcount");
            if (s != null) {
                freqmax = Long.parseLong(s);
            }
            if (freqmax < 0L) {
                freqmax = Long.MAX_VALUE;
            }
            long limit = 10L;
            s = this.params.get("terms.limit");
            if (s != null) {
                limit = Long.parseLong(s);
            }
            if (limit < 0L) {
                limit = Long.MAX_VALUE;
            }
            for (String key : this.fieldmap.keySet()) {
                SimpleOrderedMap fieldterms = new SimpleOrderedMap();
                TermsResponse.Term[] data = null;
                data = sort ? this.getCountSorted(this.fieldmap.get(key)) : this.getLexSorted(this.fieldmap.get(key));
                boolean includeTotalTermFreq = this.params.getBool("terms.ttf", false);
                int cnt = 0;
                for (TermsResponse.Term tc : data) {
                    if (tc.getFrequency() >= freqmin && tc.getFrequency() <= freqmax) {
                        if (includeTotalTermFreq) {
                            SimpleOrderedMap termStats = new SimpleOrderedMap();
                            termStats.add("df", (Object)tc.getFrequency());
                            termStats.add("ttf", (Object)tc.getTotalTermFreq());
                            fieldterms.add(tc.getTerm(), (Object)termStats);
                        } else {
                            fieldterms.add(tc.getTerm(), (Object)TermsHelper.num(tc.getFrequency()));
                        }
                        ++cnt;
                    }
                    if ((long)cnt >= limit) break;
                }
                response.add(key, (Object)fieldterms);
            }
            return response;
        }

        private static Number num(long val) {
            if (val < Integer.MAX_VALUE) {
                return (int)val;
            }
            return val;
        }

        public TermsResponse.Term[] getLexSorted(HashMap<String, TermsResponse.Term> data) {
            TermsResponse.Term[] arr = data.values().toArray(new TermsResponse.Term[data.size()]);
            Arrays.sort(arr, (o1, o2) -> o1.getTerm().compareTo(o2.getTerm()));
            return arr;
        }

        public TermsResponse.Term[] getCountSorted(HashMap<String, TermsResponse.Term> data) {
            TermsResponse.Term[] arr = data.values().toArray(new TermsResponse.Term[data.size()]);
            Arrays.sort(arr, (o1, o2) -> {
                long freq1 = o1.getFrequency();
                long freq2 = o2.getFrequency();
                if (freq2 < freq1) {
                    return -1;
                }
                if (freq1 < freq2) {
                    return 1;
                }
                return o1.getTerm().compareTo(o2.getTerm());
            });
            return arr;
        }
    }
}

