/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.Arrays;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.handler.admin.BaseHandlerApiSupport;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class ConfigSetsHandlerApi
extends BaseHandlerApiSupport {
    final ConfigSetsHandler configSetHandler;

    public ConfigSetsHandlerApi(ConfigSetsHandler configSetHandler) {
        this.configSetHandler = configSetHandler;
    }

    @Override
    protected List<BaseHandlerApiSupport.ApiCommand> getCommands() {
        return Arrays.asList(Cmd.values());
    }

    @Override
    protected List<BaseHandlerApiSupport.V2EndPoint> getEndPoints() {
        return Arrays.asList(EndPoint.values());
    }

    static enum EndPoint implements BaseHandlerApiSupport.V2EndPoint
    {
        LIST_CONFIG("cluster.configs"),
        CONFIG_COMMANDS("cluster.configs.Commands"),
        CONFIG_DEL("cluster.configs.delete");

        public final String spec;

        private EndPoint(String spec) {
            this.spec = spec;
        }

        @Override
        public String getSpecName() {
            return this.spec;
        }
    }

    static enum Cmd implements BaseHandlerApiSupport.ApiCommand
    {
        LIST(EndPoint.LIST_CONFIG, ConfigSetsHandler.ConfigSetOperation.LIST_OP, SolrRequest.METHOD.GET),
        CREATE(EndPoint.CONFIG_COMMANDS, ConfigSetsHandler.ConfigSetOperation.CREATE_OP, SolrRequest.METHOD.POST, "create"),
        DEL(EndPoint.CONFIG_DEL, ConfigSetsHandler.ConfigSetOperation.DELETE_OP, SolrRequest.METHOD.DELETE);

        private final EndPoint endPoint;
        private final ConfigSetsHandler.ConfigSetOperation op;
        private final SolrRequest.METHOD method;
        private final String cmdName;

        private Cmd(EndPoint endPoint, ConfigSetsHandler.ConfigSetOperation op, SolrRequest.METHOD method) {
            this(endPoint, op, method, null);
        }

        private Cmd(EndPoint endPoint, ConfigSetsHandler.ConfigSetOperation op, SolrRequest.METHOD method, String cmdName) {
            this.cmdName = cmdName;
            this.endPoint = endPoint;
            this.op = op;
            this.method = method;
        }

        @Override
        public String getName() {
            return this.cmdName;
        }

        @Override
        public SolrRequest.METHOD getHttpMethod() {
            return this.method;
        }

        @Override
        public BaseHandlerApiSupport.V2EndPoint getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void invoke(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) throws Exception {
            ((ConfigSetsHandlerApi)apiHandler).configSetHandler.invokeAction(req, rsp, this.op.action);
        }
    }
}

