/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.util.SimplePostTool;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobRepository {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final Random RANDOM;
    static final Pattern BLOB_KEY_PATTERN_CHECKER;
    private final CoreContainer coreContainer;
    private Map<String, BlobContent> blobs = this.createMap();

    ConcurrentHashMap<String, BlobContent> createMap() {
        return new ConcurrentHashMap<String, BlobContent>();
    }

    public BlobRepository(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    public BlobContentRef<ByteBuffer> getBlobIncRef(String key) {
        return this.getBlobIncRef(key, () -> this.addBlob(key));
    }

    BlobContentRef<Object> getBlobIncRef(String key, Decoder<Object> decoder) {
        return this.getBlobIncRef(key.concat(decoder.getName()), () -> this.addBlob(key, decoder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BlobContentRef<T> getBlobIncRef(String key, Callable<BlobContent<T>> blobCreator) {
        BlobContent<T> aBlob;
        if (this.coreContainer.isZooKeeperAware()) {
            Map<String, BlobContent> map = this.blobs;
            synchronized (map) {
                aBlob = this.blobs.get(key);
                if (aBlob == null) {
                    try {
                        aBlob = blobCreator.call();
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Blob loading failed: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Blob loading is not supported in non-cloud mode");
        BlobContentRef ref = new BlobContentRef(aBlob);
        Set set = ((BlobContent)aBlob).references;
        synchronized (set) {
            ((BlobContent)aBlob).references.add(ref);
        }
        return ref;
    }

    private BlobContent<ByteBuffer> addBlob(String key) {
        ByteBuffer b = this.fetchBlob(key);
        BlobContent<ByteBuffer> aBlob = new BlobContent<ByteBuffer>(key, b);
        this.blobs.put(key, aBlob);
        return aBlob;
    }

    private BlobContent<Object> addBlob(String key, Decoder<Object> decoder) {
        ByteBuffer b = this.fetchBlob(key);
        String keyPlusName = key + decoder.getName();
        BlobContent<Object> aBlob = new BlobContent<Object>(keyPlusName, b, decoder);
        this.blobs.put(keyPlusName, aBlob);
        return aBlob;
    }

    ByteBuffer fetchBlob(String key) {
        ByteBuffer b;
        Replica replica = this.getSystemCollReplica();
        String url = replica.getStr("base_url") + "/.system/blob/" + key + "?wt=filestream";
        HttpClient httpClient = this.coreContainer.getUpdateShardHandler().getHttpClient();
        HttpGet httpGet = new HttpGet(url);
        try {
            HttpResponse entity = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = entity.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "no such blob or version available: " + key);
            }
            b = SimplePostTool.inputStreamToByteArray(entity.getEntity().getContent());
        }
        catch (Exception e) {
            if (e instanceof SolrException) {
                throw (SolrException)((Object)e);
            }
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "could not load : " + key, (Throwable)e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return b;
    }

    private Replica getSystemCollReplica() {
        ZkStateReader zkStateReader = this.coreContainer.getZkController().getZkStateReader();
        ClusterState cs = zkStateReader.getClusterState();
        DocCollection coll = cs.getCollectionOrNull(".system");
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, ".system collection not available");
        }
        ArrayList slices = new ArrayList(coll.getActiveSlices());
        if (slices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No active slices for .system collection");
        }
        Collections.shuffle(slices, RANDOM);
        Replica replica = null;
        block0: for (Slice slice : slices) {
            ArrayList replicas = new ArrayList(slice.getReplicasMap().values());
            Collections.shuffle(replicas, RANDOM);
            for (Replica r : replicas) {
                if (r.getState() != Replica.State.ACTIVE) continue;
                if (zkStateReader.getClusterState().getLiveNodes().contains(r.get("node_name"))) {
                    replica = r;
                    continue block0;
                }
                log.info("replica {} says it is active but not a member of live nodes", r.get("node_name"));
            }
        }
        if (replica == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, ".no active replica available for .system collection");
        }
        return replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementBlobRefCount(BlobContentRef ref) {
        if (ref == null) {
            return;
        }
        Set set = ref.blob.references;
        synchronized (set) {
            if (!ref.blob.references.remove(ref)) {
                log.error("Multiple releases for the same reference");
            }
            if (ref.blob.references.isEmpty()) {
                this.blobs.remove(ref.blob.key);
            }
        }
    }

    static {
        BLOB_KEY_PATTERN_CHECKER = Pattern.compile(".*/\\d+");
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
    }

    public static class BlobContentRef<T> {
        public final BlobContent<T> blob;

        private BlobContentRef(BlobContent<T> blob) {
            this.blob = blob;
        }
    }

    public static interface Decoder<T> {
        default public String getName() {
            return "";
        }

        public T decode(InputStream var1);
    }

    public static class BlobContent<T> {
        public final String key;
        private final T content;
        private final Set<BlobContentRef> references = new HashSet<BlobContentRef>();

        public BlobContent(String key, ByteBuffer buffer, Decoder<T> decoder) {
            this.key = key;
            this.content = decoder.decode((InputStream)new ByteBufferInputStream(buffer));
        }

        public BlobContent(String key, ByteBuffer buffer) {
            this.key = key;
            this.content = buffer;
        }

        public T get() {
            return this.content;
        }
    }
}

