/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.ecw;

import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.plugins.ecw.ECWImageReader;
import it.geosolutions.imageio.plugins.ecw.ECWPImageInputStream;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import org.gdal.gdal.Dataset;
import org.gdal.gdalconst.gdalconst;

public class ECWImageReaderSpi
extends GDALImageReaderSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.ecw");
    static final String[] suffixes = new String[]{"ecw"};
    static final String[] formatNames = new String[]{"ECW", "ECWP"};
    static final String[] MIMETypes = new String[]{"image/ecw"};
    static final String version = "1.0";
    static final String description = "ECW Image Reader, version 1.0";
    static final String readerCN = "it.geosolutions.imageio.plugins.ecw.ECWImageReader";
    static final String vendorName = "GeoSolutions";
    static final String[] wSN = new String[]{null};
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = new String[]{null};
    static final String[] extraStreamMetadataFormatClassNames = new String[]{null};
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = null;
    static final String nativeImageMetadataFormatClassName = null;
    static final String[] extraImageMetadataFormatNames = new String[]{null};
    static final String[] extraImageMetadataFormatClassNames = new String[]{null};

    public ECWImageReaderSpi() {
        super(vendorName, version, formatNames, suffixes, MIMETypes, readerCN, new Class[]{File.class, FileImageInputStreamExt.class, ECWPImageInputStream.class}, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames, Collections.singletonList("ECW"));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ECWImageReaderSpi Constructor");
        }
    }

    public boolean canDecodeInput(Object input) throws IOException {
        if (input instanceof ECWPImageInputStream) {
            Dataset ds;
            String ecwp = ((ECWPImageInputStream)input).getECWPLink();
            boolean isDecodeable = false;
            if (ecwp != null && (ds = GDALUtilities.acquireDataSet((String)ecwp, (int)gdalconst.GA_ReadOnly)) != null) {
                isDecodeable = this.isDecodable(ds);
            }
            return isDecodeable;
        }
        return super.canDecodeInput(input);
    }

    public ImageReader createReaderInstance(Object source) throws IOException {
        return new ECWImageReader(this);
    }

    public String getDescription(Locale locale) {
        return description;
    }
}

