/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.util.SFTPTools$;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.rev6.scf.ScpDownload;
import org.rev6.scf.ScpFile;
import org.rev6.scf.SshCommand;
import org.rev6.scf.SshConnection;
import org.rev6.scf.SshTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.util.matching.Regex;

public final class SFTPTools$ {
    public static final SFTPTools$ MODULE$;
    private final Logger logger;
    private final Regex connectionPattern;
    private ChannelSftp channelSftp;
    private Session session;
    private final Regex sftpPattern;
    private final Ordering<ChannelSftp.LsEntry> o;

    static {
        new SFTPTools$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Regex connectionPattern() {
        return this.connectionPattern;
    }

    public ChannelSftp channelSftp() {
        return this.channelSftp;
    }

    public void channelSftp_$eq(ChannelSftp x$1) {
        this.channelSftp = x$1;
    }

    public Session session() {
        return this.session;
    }

    public void session_$eq(Session x$1) {
        this.session = x$1;
    }

    public Regex sftpPattern() {
        return this.sftpPattern;
    }

    public Option<Tuple2<String, Date>> sftpLatestArchive(String url, String resourceUid, String tempDir, Option<Date> afterDate) {
        Tuple4 tuple4;
        String string = url;
        Option option = this.connectionPattern().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
            String user = (String)((LinearSeqOptimized)option.get()).apply(0);
            String password = (String)((LinearSeqOptimized)option.get()).apply(1);
            String host = (String)((LinearSeqOptimized)option.get()).apply(2);
            String directory = (String)((LinearSeqOptimized)option.get()).apply(3);
            tuple4 = new Tuple4((Object)user, (Object)password, (Object)host, (Object)directory);
        } else {
            Option option2 = this.sftpPattern().unapplySeq((Object)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String host = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String directory = (String)((LinearSeqOptimized)option2.get()).apply(1);
                String u = Config$.MODULE$.getProperty("uploadUser");
                String p = Config$.MODULE$.getProperty("uploadPassword");
                if (StringUtils.isEmpty((CharSequence)u) || StringUtils.isEmpty((CharSequence)p)) {
                    this.logger().error("SCP User or password has not been supplied. Please supply as part of the biocache-test-config.properties");
                }
                tuple4 = new Tuple4((Object)u, (Object)p, (Object)host, (Object)directory);
            } else {
                this.logger().error(new StringBuilder().append((Object)"Unable to connect to ").append((Object)url).toString());
                tuple4 = new Tuple4(null, null, null, null);
            }
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 != null) {
            Option<Tuple2<String, Date>> option3;
            Tuple4 tuple43;
            String user = (String)tuple42._1();
            String password = (String)tuple42._2();
            String host = (String)tuple42._3();
            String directory = (String)tuple42._4();
            Tuple4 tuple44 = tuple43 = new Tuple4((Object)user, (Object)password, (Object)host, (Object)directory);
            String user2 = (String)tuple44._1();
            String password2 = (String)tuple44._2();
            String host2 = (String)tuple44._3();
            String directory2 = (String)tuple44._4();
            this.connect(host2, user2, password2, this.connect$default$4());
            Option<String> lastFile = this.getLatestFile(directory2, "*.*", afterDate);
            this.disconnect();
            if (lastFile.isDefined()) {
                String dir = new StringBuilder().append((Object)tempDir).append((Object)resourceUid).toString();
                option3 = this.scpFile(host2, user2, password2, (String)lastFile.get(), new File(new StringBuilder().append((Object)dir).append((Object)File.separator).append(lastFile.get()).toString()));
            } else {
                this.logger().error(new StringBuilder().append((Object)"No latest file for ").append((Object)url).toString());
                option3 = None$.MODULE$;
            }
            return option3;
        }
        throw new MatchError((Object)tuple42);
    }

    public void connect(String host, String user, String password, int port) {
        JSch jsch = new JSch();
        this.session_$eq(jsch.getSession(user, host, port));
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session().setConfig(config);
        this.session().setPassword(password);
        this.session().connect();
        Channel channel = this.session().openChannel("sftp");
        channel.connect();
        this.channelSftp_$eq((ChannelSftp)channel);
    }

    public int connect$default$4() {
        return 22;
    }

    public void disconnect() {
        this.channelSftp().disconnect();
        this.session().disconnect();
    }

    public Option<String> getLatestFile(String dir, String filePattern, Option<Date> afterDate) {
        Object object;
        List<ChannelSftp.LsEntry> list = this.listFiles(new StringBuilder().append((Object)dir).append((Object)File.separator).append((Object)filePattern).toString());
        if (list.isEmpty()) {
            object = None$.MODULE$;
        } else {
            ChannelSftp.LsEntry item = (ChannelSftp.LsEntry)list.reduceLeft((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ChannelSftp.LsEntry apply(ChannelSftp.LsEntry a, ChannelSftp.LsEntry b) {
                    return a.getAttrs().getMTime() > b.getAttrs().getMTime() ? a : b;
                }
            });
            object = afterDate.isEmpty() || ((Date)afterDate.get()).getTime() / 1000L < (long)item.getAttrs().getMTime() ? new Some((Object)new StringBuilder().append((Object)dir).append((Object)File.separator).append((Object)item.getFilename()).toString()) : None$.MODULE$;
        }
        return object;
    }

    public Ordering<ChannelSftp.LsEntry> o() {
        return this.o;
    }

    public List<ChannelSftp.LsEntry> listFiles(String filePattern) {
        Vector vector = this.channelSftp().ls(filePattern);
        return (List)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)vector).toList().sorted(this.o().reverse());
    }

    public Option<Tuple2<String, Date>> scpFile(String host, String user, String password, String remoteFile, File localFile) {
        None$ none$;
        if (StringUtils.isEmpty((CharSequence)user) || StringUtils.isEmpty((CharSequence)password)) {
            this.logger().error("SCP User or password has not been supplied. Please supply as part of the biocache-test-config.properties");
        }
        SshConnection ssh = null;
        try {
            try {
                Date date;
                ssh = new SshConnection(host, user, password);
                ssh.connect();
                FileUtils.forceMkdir((File)localFile.getParentFile());
                ScpFile scpFile = new ScpFile(localFile, remoteFile);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                SshCommand command = new SshCommand(new StringBuilder().append((Object)"date -r ").append((Object)remoteFile).append((Object)" +%s").toString(), (OutputStream)outputStream);
                try {
                    ssh.executeTask((SshTask)command);
                    String stringvalue = outputStream.toString();
                    date = new Date(new StringOps(Predef$.MODULE$.augmentString(stringvalue.trim())).toLong() * 1000L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    date = new Date();
                }
                Date date2 = date;
                ssh.executeTask((SshTask)new ScpDownload(scpFile));
                none$ = new Some((Object)new Tuple2((Object)localFile.getAbsolutePath(), (Object)date2));
            }
            catch (Exception exception) {
                this.logger().error(new StringBuilder().append((Object)"Unable to SCP ").append((Object)remoteFile).toString(), (Throwable)exception);
                none$ = None$.MODULE$;
            }
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
        return none$;
    }

    private SFTPTools$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"SFTPTools");
        this.connectionPattern = new StringOps(Predef$.MODULE$.augmentString("sftp://([a-zA-Z]*):([a-zA-Z]*)@([a-zA-z\\.]*):([a-zA-Z/]*)")).r();
        this.logger().debug(this.connectionPattern().toString());
        this.channelSftp = null;
        this.session = null;
        this.sftpPattern = new StringOps(Predef$.MODULE$.augmentString("sftp://([a-zA-z\\.]*):([0-9a-zA-Z_/\\.\\-]*)")).r();
        this.o = package$.MODULE$.Ordering().by((Function1)new anonfun.2(), (Ordering)Ordering.Int$.MODULE$);
    }
}

