/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.BasisOfRecord$;
import au.org.ala.biocache.vocab.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u001b\t1\")Y:jg>3'+Z2pe\u0012\u0004&o\\2fgN|'O\u0003\u0002\u0004\t\u0005I\u0001O]8dKN\u001cxN\u001d\u0006\u0003\u000b\u0019\t\u0001BY5pG\u0006\u001c\u0007.\u001a\u0006\u0003\u000f!\t1!\u00197b\u0015\tI!\"A\u0002pe\u001eT\u0011aC\u0001\u0003CV\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005%\u0001&o\\2fgN|'\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011Q\u0003\u0001\u0005\b;\u0001\u0011\r\u0011\"\u0001\u001f\u0003\u0019awnZ4feV\tq\u0004\u0005\u0002!I5\t\u0011E\u0003\u0002#G\u0005)1\u000f\u001c45U*\t\u0011\"\u0003\u0002&C\t1Aj\\4hKJDaa\n\u0001!\u0002\u0013y\u0012a\u00027pO\u001e,'\u000f\t\u0005\u0006S\u0001!\tAK\u0001\baJ|7-Z:t)\u0015YC'\u0010\"E!\ryAFL\u0005\u0003[A\u0011Q!\u0011:sCf\u0004\"a\f\u001a\u000e\u0003AR!!\r\u0003\u0002\u000b5|G-\u001a7\n\u0005M\u0002$\u0001E)vC2LG/_!tg\u0016\u0014H/[8o\u0011\u0015)\u0004\u00061\u00017\u0003\u00119W/\u001b3\u0011\u0005]RdBA\b9\u0013\tI\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u0012aa\u0015;sS:<'BA\u001d\u0011\u0011\u0015q\u0004\u00061\u0001@\u0003\r\u0011\u0018m\u001e\t\u0003_\u0001K!!\u0011\u0019\u0003\u0015\u0019+H\u000e\u001c*fG>\u0014H\rC\u0003DQ\u0001\u0007q(A\u0005qe>\u001cWm]:fI\"9Q\t\u000bI\u0001\u0002\u00041\u0015!\u00047bgR\u0004&o\\2fgN,G\rE\u0002\u0010\u000f~J!\u0001\u0013\t\u0003\r=\u0003H/[8o\u0011\u0015Q\u0005\u0001\"\u0001L\u0003\u0011\u00198.\u001b9\u0015\u000b-bUJT(\t\u000bUJ\u0005\u0019\u0001\u001c\t\u000byJ\u0005\u0019A \t\u000b\rK\u0005\u0019A \t\u000f\u0015K\u0005\u0013!a\u0001\r\")\u0011\u000b\u0001C\u0001%\u00069q-\u001a;OC6,G#A*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016\u0001\u00027b]\u001eT\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002<+\"91\fAI\u0001\n\u0003b\u0016!\u00059s_\u000e,7o\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\tQL\u000b\u0002G=.\nq\f\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003IB\t!\"\u00198o_R\fG/[8o\u0013\t1\u0017MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq\u0001\u001b\u0001\u0012\u0002\u0013\u0005C,\u0001\btW&\u0004H\u0005Z3gCVdG\u000f\n\u001b")
public class BasisOfRecordProcessor
implements Processor {
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        QualityAssertion[] qualityAssertionArray;
        if (raw.occurrence().basisOfRecord() == null || raw.occurrence().basisOfRecord().isEmpty()) {
            qualityAssertionArray = processed.occurrence().basisOfRecord() == null || processed.occurrence().basisOfRecord().isEmpty() ? (QualityAssertion[])((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_BASIS_OF_RECORD(), "Missing basis of record")}) : (QualityAssertion[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(QualityAssertion.class));
        } else {
            Option<Term> term = BasisOfRecord$.MODULE$.matchTerm(raw.occurrence().basisOfRecord());
            if (term.isEmpty()) {
                this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ").append((Object)guid).append((Object)", unrecognised BoR: ").append((Object)guid).append((Object)", BoR:").append((Object)raw.occurrence().basisOfRecord()).toString());
                qualityAssertionArray = (QualityAssertion[])((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.BADLY_FORMED_BASIS_OF_RECORD(), "Unrecognised basis of record"), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_BASIS_OF_RECORD(), AssertionStatus$.MODULE$.PASSED())});
            } else {
                processed.occurrence().basisOfRecord_$eq(((Term)term.get()).canonical());
                qualityAssertionArray = (QualityAssertion[])((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_BASIS_OF_RECORD(), AssertionStatus$.MODULE$.PASSED()), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.BADLY_FORMED_BASIS_OF_RECORD(), AssertionStatus$.MODULE$.PASSED())});
            }
        }
        return qualityAssertionArray;
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    @Override
    public QualityAssertion[] skip(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        ArrayBuffer assertions = new ArrayBuffer();
        if (lastProcessed.isDefined()) {
            assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])((FullRecord)lastProcessed.get()).findAssertions(new int[]{AssertionCodes$.MODULE$.MISSING_BASIS_OF_RECORD().code(), AssertionCodes$.MODULE$.BADLY_FORMED_BASIS_OF_RECORD().code()})));
            processed.occurrence().basisOfRecord_$eq(((FullRecord)lastProcessed.get()).occurrence().basisOfRecord());
        }
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> skip$default$4() {
        return None$.MODULE$;
    }

    @Override
    public String getName() {
        return "bor";
    }

    public BasisOfRecordProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"BasisOfRecordProcessor");
    }
}

