/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index.lucene;

import au.org.ala.biocache.Config;
import au.org.ala.biocache.index.lucene.LuceneIndexing;
import au.org.ala.biocache.index.lucene.RecycleDoc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class DocBuilder {
    private static final Logger logger = Logger.getLogger(DocBuilder.class);
    private static ConcurrentHashMap<String, String> additionalSchemaEntries = new ConcurrentHashMap();
    private static Boolean isIndexing = true;
    private LuceneIndexing index;
    private IndexSchema schema;
    private Map<String, SchemaObject> schemaMap = new HashMap<String, SchemaObject>();
    private String currentId = "";
    private RecycleDoc doc;
    private boolean closed = true;

    DocBuilder(IndexSchema schema, LuceneIndexing index) {
        this.schema = schema;
        this.index = index;
    }

    public String getId() {
        return this.currentId;
    }

    public void newDoc(String id) throws InterruptedException {
        this.currentId = id;
        if (this.closed) {
            this.doc = this.index.nextDoc();
        } else {
            logger.warn((Object)"Document was not indexed or released before calling DocBuilder.newDoc again.");
        }
        this.doc.reset();
        this.closed = false;
    }

    public void release() throws InterruptedException {
        if (!this.closed) {
            this.index.release(this.doc);
            this.closed = true;
        }
    }

    public void index() throws IOException, InterruptedException {
        if (this.closed) {
            logger.error((Object)"DocBuilder.index() was called before newDoc() or after release(). Document not indexed.");
        } else {
            this.index.addDoc(this.doc);
            this.closed = true;
        }
    }

    public void addField(String field, Object value) {
        this.addField(field, value, true);
    }

    public void addField(String field, Object value, Boolean index) {
        if (field == null || field.isEmpty() || value == null || value.toString().isEmpty()) {
            return;
        }
        boolean reused = false;
        if (this.doc.setField(field, value)) {
            reused = true;
        }
        boolean used = false;
        SchemaObject s = this.schemaMap.get(field);
        if (s == null) {
            SchemaField f = this.schema.getFieldOrNull(field);
            if (f == null) {
                if (additionalSchemaEntries.get(field) == null) {
                    this.makeField(field, index);
                }
                return;
            }
            List cf = this.schema.getCopyFieldsList(field);
            s = new SchemaObject(f, cf);
            this.schemaMap.put(field, s);
        }
        SchemaField sf = s.field;
        List copyField = s.copyFieldsList;
        if (isIndexing.booleanValue()) {
            try {
                if (sf != null && !reused) {
                    used = true;
                    this.addField(this.doc, sf, value);
                }
                if (copyField != null) {
                    for (CopyField cf : copyField) {
                        SchemaField destinationField = cf.getDestination();
                        used = true;
                        if (value instanceof String && cf.getMaxChars() > 0) {
                            value = cf.getLimitedValue((String)value);
                        }
                        if (this.doc.setField(destinationField.getName(), value)) continue;
                        this.addField(this.doc, destinationField, value);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("failed to add a field to id:'" + this.currentId + "' '" + field + "'='" + value + "' msg=" + ex.getMessage()));
            }
            if (!used && !reused) {
                logger.info((Object)("unknown field id:'" + this.currentId + "' '" + field + "'"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaField makeField(String field, Boolean index) {
        SchemaField sf;
        boolean stored = Config.schemaStoredMisc();
        boolean multiValued = Config.schemaMultiValuedMisc();
        boolean docValues = Config.schemaDocValuesMisc();
        int properties = (index != false ? 1 : 0) + 4 + 16;
        if (field.matches("^el[0-9]*$")) {
            sf = new SchemaField(field, this.schema.getFieldTypeByName(Config.schemaFieldTypeEl()), properties, null);
            stored = Config.schemaStoredLayer();
            multiValued = Config.schemaMultiValuedLayer();
            docValues = Config.schemaDocValuesLayer();
        } else if (field.matches("^cl[0-9]*$")) {
            sf = new SchemaField(field, this.schema.getFieldTypeByName(Config.schemaFieldTypeCl()), properties, null);
            stored = Config.schemaStoredLayer();
            multiValued = Config.schemaMultiValuedLayer();
            docValues = Config.schemaDocValuesLayer();
        } else {
            sf = field.endsWith("_i") || field.endsWith("_i_rng") ? new SchemaField(field, this.schema.getFieldTypeByName("tint"), properties, null) : (field.endsWith("_l") && !field.endsWith("_per_l") ? new SchemaField(field, this.schema.getFieldTypeByName("tlong"), properties, null) : (field.endsWith("_d") || field.endsWith("_d_rng") || field.endsWith("_per_l") ? new SchemaField(field, this.schema.getFieldTypeByName("tdouble"), properties, null) : (field.endsWith("_f") ? new SchemaField(field, this.schema.getFieldTypeByName("tfloat"), properties, null) : (field.endsWith("_dt") ? new SchemaField(field, this.schema.getFieldTypeByName("tdate"), properties, null) : new SchemaField(field, this.schema.getFieldTypeByName(Config.schemaFieldTypeMisc()), properties, null)))));
        }
        IndexSchema indexSchema = this.schema;
        synchronized (indexSchema) {
            String exists = additionalSchemaEntries.get(field);
            if (exists == null) {
                additionalSchemaEntries.put(field, "<field name=\"" + field + "\" type=\"" + sf.getType().getTypeName() + "\" indexed=\"" + index + "\" stored=\"" + stored + "\" omitNorms=\"true\" multiValued=\"" + multiValued + "\" docValues=\"" + docValues + "\"/>");
            }
        }
        return sf;
    }

    private void addField(RecycleDoc doc, SchemaField field, Object val) {
        try {
            if (val instanceof IndexableField) {
                ((Field)val).setBoost(1.0f);
                ArrayList<IndexableField> list = new ArrayList<IndexableField>();
                list.add((IndexableField)val);
                doc.add(field, list);
            } else {
                List list = field.getType().createFields(field, val, 1.0f);
                if (!list.isEmpty() && list.get(0) == null) {
                    logger.error((Object)("schema definition of field '" + field.getName() + "' is invalid and will be ignored."));
                } else {
                    doc.add(field, list);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("adding one field '" + this.currentId + "' '" + field.getName() + "' = '" + val.toString() + "' > " + e.getMessage()));
        }
    }

    public RecycleDoc getDoc() {
        return this.doc;
    }

    public static Collection<String> getAdditionalSchemaEntries() {
        return new ArrayList<String>(additionalSchemaEntries.values());
    }

    public static void setIsIndexing(Boolean isIndexing) {
        DocBuilder.isIndexing = isIndexing;
    }

    public static Boolean isIndexing() {
        return isIndexing;
    }

    class SchemaObject {
        private final SchemaField field;
        private final List<CopyField> copyFieldsList;

        SchemaObject(SchemaField fieldOrNull, List<CopyField> copyFieldsList) {
            this.field = fieldOrNull;
            this.copyFieldsList = copyFieldsList;
        }
    }
}

