/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.NumberEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DivideEvaluator
extends NumberEvaluator {
    protected static final long serialVersionUID = 1L;

    public DivideEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Number evaluate(Tuple tuple) throws IOException {
        List<BigDecimal> results = this.evaluateAll(tuple);
        if (2 != results.size()) {
            String message = null;
            message = 1 == results.size() ? String.format(Locale.ROOT, "%s(...) only works with a 2 values (numerator,denominator) but 1 was provided", this.constructingFactory.getFunctionName(this.getClass())) : String.format(Locale.ROOT, "%s(...) only works with a 2 values (numerator,denominator) but %d were provided", this.constructingFactory.getFunctionName(this.getClass()), results.size());
            throw new IOException(message);
        }
        BigDecimal numerator = results.get(0);
        BigDecimal denominator = results.get(1);
        if (null == numerator) {
            throw new IOException(String.format(Locale.ROOT, "Unable to %s(...) with a null numerator", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (null == denominator) {
            throw new IOException(String.format(Locale.ROOT, "Unable to %s(...) with a null denominator", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (0 == denominator.compareTo(BigDecimal.ZERO)) {
            throw new IOException(String.format(Locale.ROOT, "Unable to %s(...) with a 0 denominator", this.constructingFactory.getFunctionName(this.getClass())));
        }
        return this.normalizeType(numerator.divide(denominator, MathContext.DECIMAL64));
    }
}

