/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;
import org.gbif.crawler.strategy.AbstractStrategy;
import org.gbif.crawler.strategy.ScientificNameRangeCrawlContext;

@NotThreadSafe
public class ScientificNameRangeStrategy
extends AbstractStrategy<ScientificNameRangeCrawlContext> {
    private boolean isFirst = true;
    private final Mode mode;
    private final ScientificNameRangeCrawlContext context;

    public ScientificNameRangeStrategy(ScientificNameRangeCrawlContext context) {
        this(context, Mode.AAAB);
    }

    public ScientificNameRangeStrategy(ScientificNameRangeCrawlContext context, Mode mode) {
        this.context = (ScientificNameRangeCrawlContext)Preconditions.checkNotNull((Object)context, (Object)"context can't be null");
        this.mode = mode;
    }

    @Override
    public ScientificNameRangeCrawlContext next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There are no more elements in this crawl range");
        }
        if (this.isFirst) {
            this.isFirst = false;
            return this.context;
        }
        if (!this.context.getUpperBound().isPresent()) {
            this.context.setLowerBoundAbsent();
            return this.context;
        }
        this.context.setLowerBound((String)this.context.getUpperBound().get());
        if (this.mode == Mode.AAAB && ((String)this.context.getLowerBound().get()).equals("Zza") || this.mode != Mode.AAAB && ((String)this.context.getLowerBound().get()).equals("Zaa")) {
            this.context.setUpperBound(null);
            return this.context;
        }
        char[] chars = ((String)this.context.getUpperBound().get()).toCharArray();
        if (this.mode == Mode.AAAB) {
            for (int pos = 1; pos >= 0; --pos) {
                if (chars[pos] != 'z') {
                    int n = pos;
                    chars[n] = (char)(chars[n] + '\u0001');
                    break;
                }
                chars[pos] = 97;
            }
        } else {
            chars[0] = this.mode == Mode.ABC ? (int)(chars[0] + '\u0001') : 90;
        }
        this.context.setUpperBound(new String(chars));
        return this.context;
    }

    @Override
    public boolean hasNext() {
        return this.context.getUpperBound().isPresent() || this.context.getLowerBound().isPresent();
    }

    @VisibleForTesting
    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        AAAB,
        ABC,
        AZ;

    }
}

