/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.protocol.tapir;

import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.http.client.utils.URIBuilder;
import org.gbif.crawler.RequestHandler;
import org.gbif.crawler.protocol.tapir.TapirCrawlConfiguration;
import org.gbif.crawler.strategy.ScientificNameRangeCrawlContext;

@NotThreadSafe
public class TapirScientificNameRangeRequestHandler
implements RequestHandler<ScientificNameRangeCrawlContext, String> {
    private static final Map<String, String> TEMPLATE_MAPPING = new HashMap<String, String>();
    private static final int MAX_RESULTS = 1000;
    private final String contentNamespace;
    private final URI targetUrl;

    public TapirScientificNameRangeRequestHandler(TapirCrawlConfiguration configuration) {
        this.contentNamespace = configuration.getContentNamespace();
        this.targetUrl = configuration.getUrl();
    }

    private Map<String, String> buildTapirRequestParameters(ScientificNameRangeCrawlContext context) {
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("limit", String.valueOf(1000));
        if (context.getUpperBound().isPresent()) {
            params.put("upper", context.getUpperBound().get());
        } else {
            params.put("upper", null);
        }
        if (context.getLowerBound().isPresent()) {
            params.put("lower", context.getLowerBound().get());
        } else {
            params.put("lower", null);
        }
        params.put("t", TEMPLATE_MAPPING.get(this.contentNamespace));
        params.put("op", "s");
        params.put("start", String.valueOf(context.getOffset()));
        return params;
    }

    @Override
    public String buildRequestUrl(ScientificNameRangeCrawlContext context) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.targetUrl);
            for (Map.Entry<String, String> paramEntry : this.buildTapirRequestParameters(context).entrySet()) {
                uriBuilder.addParameter(paramEntry.getKey(), paramEntry.getValue());
            }
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public int getLimit() {
        return 1000;
    }

    static {
        TEMPLATE_MAPPING.put("http://rs.tdwg.org/dwc/dwcore/", "http://rs.gbif.org/templates/tapir/dwc/1.4/sci_name_range.xml");
        TEMPLATE_MAPPING.put("http://rs.tdwg.org/dwc/geospatial/", "http://rs.gbif.org/templates/tapir/dwc/1.4/sci_name_range.xml");
        TEMPLATE_MAPPING.put("http://rs.tdwg.org/dwc/curatorial/", "http://rs.gbif.org/templates/tapir/dwc/1.4/sci_name_range.xml");
        TEMPLATE_MAPPING.put("http://rs.tdwg.org/dwc/terms/", "http://rs.tdwg.org/tapir/cs/dwc/terms/2009-09-23/template/dwc_sci_name_range.xml");
        TEMPLATE_MAPPING.put("http://digir.net/schema/conceptual/darwin/2003/1.0", "http://rs.gbif.org/templates/tapir/dwc/1.0/sci_name_range.xml");
        TEMPLATE_MAPPING.put("http://www.tdwg.org/schemas/abcd/1.2", "http://rs.gbif.org/templates/tapir/abcd/1.2/sci_name_range.xml");
        TEMPLATE_MAPPING.put("http://www.tdwg.org/schemas/abcd/2.06", "http://rs.gbif.org/templates/tapir/abcd/206/sci_name_range.xml");
        TEMPLATE_MAPPING.put("http://www.tdwg.org/schemas/abcd/2.05", TEMPLATE_MAPPING.get("http://www.tdwg.org/schemas/abcd/2.06"));
    }
}

