/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.protocol.digir;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.gbif.crawler.CrawlConfiguration;

@ThreadSafe
public class DigirCrawlConfiguration
extends CrawlConfiguration {
    private final String resourceCode;
    private final boolean manis;

    public DigirCrawlConfiguration(UUID datasetKey, int attempt, URI url, String resourceCode, boolean manis) {
        super(datasetKey, url, attempt);
        this.resourceCode = (String)Preconditions.checkNotNull((Object)resourceCode, (Object)"resourceCode can't be null");
        Preconditions.checkArgument((!resourceCode.isEmpty() ? 1 : 0) != 0, (Object)"resourceCode can't be empty");
        this.manis = manis;
    }

    public String getResourceCode() {
        return this.resourceCode;
    }

    public boolean isManis() {
        return this.manis;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DigirCrawlConfiguration)) {
            return false;
        }
        DigirCrawlConfiguration other = (DigirCrawlConfiguration)obj;
        return super.equals(other) && Objects.equal((Object)this.resourceCode, (Object)other.resourceCode) && Objects.equal((Object)this.manis, (Object)other.manis);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.resourceCode, this.manis});
    }

    public String toString() {
        return this.toStringHelper().add("resourceCode", (Object)this.resourceCode).add("manis", this.manis).toString();
    }
}

