/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.gbif.crawler.RequestHandler;
import org.gbif.crawler.strategy.ScientificNameRangeCrawlContext;
import org.gbif.crawler.util.TemplateUtils;

public abstract class AbstractScientificNameRangeRequestHandler
implements RequestHandler<ScientificNameRangeCrawlContext, String> {
    private final String rangeTemplateLocation;
    private final String nullTemplateLocation;
    private final String requestParamKey;
    private final URI targetUrl;

    protected AbstractScientificNameRangeRequestHandler(URI targetUrl, String rangeTemplateLocation, String nullTemplateLocation, String requestParamKey) {
        this.targetUrl = (URI)Preconditions.checkNotNull((Object)targetUrl);
        this.rangeTemplateLocation = (String)Preconditions.checkNotNull((Object)rangeTemplateLocation);
        this.nullTemplateLocation = (String)Preconditions.checkNotNull((Object)nullTemplateLocation);
        this.requestParamKey = (String)Preconditions.checkNotNull((Object)requestParamKey);
        Resources.getResource((String)rangeTemplateLocation);
        Resources.getResource((String)nullTemplateLocation);
    }

    @Override
    public String buildRequestUrl(ScientificNameRangeCrawlContext context) {
        Preconditions.checkNotNull((Object)context);
        try {
            return new URIBuilder(this.targetUrl).addParameter(this.requestParamKey, this.buildRequest(context)).build().toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String buildRequest(ScientificNameRangeCrawlContext context) {
        HashMap<String, Object> templateContext = new HashMap<String, Object>((Map<String, Object>)this.getDefaultContext());
        String templateLocation = this.nullTemplateLocation;
        templateContext.put("startAt", String.valueOf(context.getOffset()));
        if (context.getLowerBound().isPresent()) {
            templateContext.put("lower", context.getLowerBound().get());
            templateLocation = this.rangeTemplateLocation;
        }
        if (context.getUpperBound().isPresent()) {
            templateContext.put("upper", context.getUpperBound().get());
            templateLocation = this.rangeTemplateLocation;
        }
        try {
            return TemplateUtils.getAndProcess(templateLocation, templateContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to generate request", e);
        }
    }

    protected abstract ImmutableMap<String, Object> getDefaultContext();
}

