/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.CompositeHelper;
import org.restlet.routing.Filter;
import org.restlet.service.Service;

public class ApplicationHelper
extends CompositeHelper<Application> {
    public ApplicationHelper(Application application) {
        super(application);
    }

    @Override
    public void handle(Request request, Response response) {
        Application.setCurrent((Application)this.getHelped());
        super.handle(request, response);
    }

    public void setContext(Context context) {
        if (context != null) {
            this.setOutboundNext(context.getClientDispatcher());
        }
    }

    @Override
    public synchronized void start() throws Exception {
        Filter filter = null;
        for (Service service : ((Application)this.getHelped()).getServices()) {
            if (!service.isEnabled()) continue;
            filter = service.createInboundFilter(this.getContext() == null ? null : this.getContext().createChildContext());
            if (filter != null) {
                this.addInboundFilter(filter);
            }
            if ((filter = service.createOutboundFilter(this.getContext() == null ? null : this.getContext().createChildContext())) == null) continue;
            this.addOutboundFilter(filter);
        }
        this.setInboundNext(((Application)this.getHelped()).getInboundRoot());
        if (this.getOutboundNext() == null) {
            this.getLogger().fine("By default, an application should be attached to a parent component in order to let application's outbound root handle calls properly.");
            this.setOutboundNext(new Restlet(){
                Map<Protocol, Client> clients = new ConcurrentHashMap<Protocol, Client>();

                @Override
                public void handle(Request request, Response response) {
                    Protocol protocol;
                    Protocol rProtocol = request.getProtocol();
                    Reference rReference = request.getResourceRef();
                    Protocol protocol2 = rProtocol != null ? rProtocol : (protocol = rReference != null ? rReference.getSchemeProtocol() : null);
                    if (protocol != null) {
                        Client c = this.clients.get(protocol);
                        if (c == null) {
                            c = new Client(protocol);
                            this.clients.put(protocol, c);
                            this.getLogger().fine("Added runtime client for protocol: " + protocol.getName());
                        }
                        c.handle(request, response);
                    } else {
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, "The server isn't properly configured to handle client calls.");
                        this.getLogger().warning("There is no protocol detected for this request: " + request.getResourceRef());
                    }
                }

                @Override
                public synchronized void stop() throws Exception {
                    super.stop();
                    for (Client client : this.clients.values()) {
                        client.stop();
                    }
                }
            });
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        this.clear();
    }

    @Override
    public void update() throws Exception {
    }
}

