/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.text;

import java.util.Comparator;
import org.apache.commons.lang3.text.StrTokenizer;
import org.gbif.common.shaded.com.google.common.collect.Ordering;

public class LineComparator
implements Comparator<String> {
    private final StrTokenizer tokenizer;
    private final int column;
    private final Comparator<String> comp;

    public LineComparator(int column, String columnDelimiter) {
        this(column, columnDelimiter, null, null);
    }

    public LineComparator(int column, String columnDelimiter, Character quoteChar) {
        this(column, columnDelimiter, quoteChar, null);
    }

    public LineComparator(int column, String columnDelimiter, Character quoteChar, Comparator<String> columnComparator) {
        this.column = column;
        this.comp = columnComparator == null ? Ordering.natural().nullsFirst() : columnComparator;
        this.tokenizer = new StrTokenizer();
        this.tokenizer.setEmptyTokenAsNull(true);
        this.tokenizer.setIgnoreEmptyTokens(false);
        if (quoteChar != null) {
            this.tokenizer.setQuoteChar(quoteChar.charValue());
        }
        this.tokenizer.setDelimiterString(columnDelimiter);
    }

    public LineComparator(int column, String columnDelimiter, Comparator<String> columnComparator) {
        this(column, columnDelimiter, null, null);
    }

    @Override
    public int compare(String o1, String o2) {
        if (o1 == null || o2 == null) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            return -1;
        }
        this.tokenizer.reset(o1);
        String[] parts = this.tokenizer.getTokenArray();
        String s1 = null;
        if (parts != null && parts.length > this.column) {
            s1 = parts[this.column];
        }
        this.tokenizer.reset(o2);
        parts = this.tokenizer.getTokenArray();
        String s2 = null;
        if (parts != null && parts.length > this.column) {
            s2 = parts[this.column];
        }
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        return this.comp.compare(s1, s2);
    }

    public Comparator<String> getColumnComparator() {
        return this.comp;
    }
}

