/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.legend;

import au.org.ala.layers.legend.FieldTypeDeserializer;
import au.org.ala.layers.legend.GroupTypeDeserializer;
import au.org.ala.layers.legend.LegendBuilder;
import au.org.ala.layers.legend.LegendObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

public class QueryField
implements Serializable {
    @JsonDeserialize(using=GroupTypeDeserializer.class)
    GroupType group = GroupType.CUSTOM;
    String name;
    String displayName;
    boolean store;
    ArrayList<String> tmpData = new ArrayList();
    @JsonDeserialize(using=FieldTypeDeserializer.class)
    FieldType fieldType = FieldType.AUTO;
    long[] longData = null;
    int[] intData = null;
    String[] stringData = null;
    float[] floatData = null;
    double[] doubleData = null;
    int[] stringCounts = null;
    LegendObject legend;

    public QueryField() {
    }

    public QueryField(String name) {
        this.name = name;
        this.displayName = name;
        this.store = false;
        this.fieldType = FieldType.AUTO;
    }

    public QueryField(String name, FieldType fieldType) {
        this.name = name;
        this.displayName = name;
        this.store = false;
        this.fieldType = fieldType;
    }

    public QueryField(String name, String displayName, FieldType fieldType) {
        this.name = name;
        this.displayName = displayName;
        this.store = false;
        this.fieldType = fieldType;
    }

    public QueryField(String name, String displayName, GroupType group, FieldType fieldType) {
        this.name = name;
        this.displayName = displayName;
        this.group = group;
        this.store = false;
        this.fieldType = fieldType;
    }

    public QueryField(String name, String displayName, GroupType group, FieldType fieldType, boolean store) {
        this.name = name;
        this.displayName = displayName;
        this.group = group;
        this.store = store;
        this.fieldType = fieldType;
    }

    public boolean isStored() {
        return this.store;
    }

    public void setStored(boolean store) {
        this.store = store;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void ensureCapacity(int size) {
        if (this.tmpData != null) {
            this.tmpData.ensureCapacity(size);
        }
    }

    public void add(String s) {
        if (this.tmpData != null) {
            s = s == null ? "" : s.trim();
            this.tmpData.add(s);
        }
    }

    public void store() {
        if (this.tmpData == null) {
            return;
        }
        if (this.fieldType == FieldType.AUTO) {
            this.updateFieldType();
        }
        switch (this.fieldType) {
            case INT: {
                this.storeAsInt();
                break;
            }
            case LONG: {
                this.storeAsLong();
                break;
            }
            case FLOAT: {
                this.storeAsFloat();
                break;
            }
            case DOUBLE: {
                this.storeAsDouble();
                break;
            }
            default: {
                this.storeAsString();
            }
        }
        this.tmpData = null;
    }

    void storeAsInt() {
        this.intData = new int[this.tmpData.size()];
        for (int i = 0; i < this.intData.length; ++i) {
            try {
                this.intData[i] = Integer.parseInt(this.tmpData.get(i));
                continue;
            }
            catch (Exception e) {
                try {
                    this.intData[i] = (int)Double.parseDouble(this.tmpData.get(i));
                    continue;
                }
                catch (Exception ex) {
                    this.intData[i] = Integer.MIN_VALUE;
                }
            }
        }
    }

    void storeAsLong() {
        this.longData = new long[this.tmpData.size()];
        for (int i = 0; i < this.longData.length; ++i) {
            try {
                this.longData[i] = Long.parseLong(this.tmpData.get(i));
                continue;
            }
            catch (Exception e) {
                try {
                    this.longData[i] = (long)Double.parseDouble(this.tmpData.get(i));
                    continue;
                }
                catch (Exception ex) {
                    this.longData[i] = Long.MIN_VALUE;
                }
            }
        }
    }

    void storeAsFloat() {
        this.floatData = new float[this.tmpData.size()];
        for (int i = 0; i < this.floatData.length; ++i) {
            try {
                this.floatData[i] = Float.parseFloat(this.tmpData.get(i));
                continue;
            }
            catch (Exception e) {
                this.floatData[i] = Float.NaN;
            }
        }
    }

    void storeAsDouble() {
        this.doubleData = new double[this.tmpData.size()];
        for (int i = 0; i < this.doubleData.length; ++i) {
            try {
                this.doubleData[i] = Double.parseDouble(this.tmpData.get(i));
                continue;
            }
            catch (Exception e) {
                this.doubleData[i] = Double.NaN;
            }
        }
    }

    void storeAsString() {
        int i;
        TreeSet<String> uniqueStrings = new TreeSet<String>();
        for (i = 0; i < this.tmpData.size(); ++i) {
            uniqueStrings.add(this.tmpData.get(i));
        }
        this.stringData = new String[uniqueStrings.size()];
        uniqueStrings.toArray(this.stringData);
        Arrays.sort(this.stringData);
        this.stringCounts = new int[this.stringData.length];
        this.intData = new int[this.tmpData.size()];
        for (i = 0; i < this.tmpData.size(); ++i) {
            int pos;
            this.intData[i] = pos = Arrays.binarySearch(this.stringData, this.tmpData.get(i));
            int n = pos;
            this.stringCounts[n] = this.stringCounts[n] + 1;
        }
    }

    private void updateFieldType() {
        if (this.tmpData == null) {
            return;
        }
        int intCount = 0;
        int longCount = 0;
        int floatCount = 0;
        int doubleCount = 0;
        int stringCount = 0;
        for (int i = 0; i < this.tmpData.size(); ++i) {
            String s = this.tmpData.get(i);
            if (s.equals("n/a")) {
                s = null;
            }
            if (s == null || s.length() <= 0) continue;
            try {
                Long.parseLong(s);
                ++longCount;
                Integer.parseInt(s);
                ++intCount;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Double.parseDouble(s);
                ++doubleCount;
                Float.parseFloat(s);
                ++floatCount;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++stringCount;
        }
        FieldType determinedType = stringCount <= 1 || stringCount > longCount && stringCount > doubleCount ? FieldType.STRING : (doubleCount > longCount ? (floatCount == doubleCount ? FieldType.FLOAT : FieldType.DOUBLE) : (intCount == longCount ? FieldType.INT : FieldType.LONG));
        this.fieldType = determinedType;
    }

    public String toString() {
        return "QueryField [group=" + (Object)((Object)this.group) + ", name=" + this.name + ", displayName=" + this.displayName + ", store=" + this.store + ", fieldType=" + (Object)((Object)this.fieldType) + ", legend=" + this.legend + "]";
    }

    public GroupType getGroup() {
        return this.group;
    }

    public void setGroup(GroupType group) {
        this.group = group;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public int getInt(int pos) {
        return this.intData[pos];
    }

    public long getLong(int pos) {
        return this.longData[pos];
    }

    public double getDouble(int pos) {
        return this.doubleData[pos];
    }

    public float getFloat(int pos) {
        return this.floatData[pos];
    }

    public String getString(int pos) {
        return this.stringData[this.intData[pos]];
    }

    public String getAsString(int pos) {
        switch (this.fieldType) {
            case INT: {
                return String.valueOf(this.intData[pos] == Integer.MIN_VALUE ? "n/a" : Integer.valueOf(this.intData[pos]));
            }
            case LONG: {
                return String.valueOf(this.longData[pos] == Long.MIN_VALUE ? "n/a" : Long.valueOf(this.longData[pos]));
            }
            case FLOAT: {
                return String.valueOf(Float.isNaN(this.floatData[pos]) ? "n/a" : Float.valueOf(this.floatData[pos]));
            }
            case DOUBLE: {
                return String.valueOf(Double.isNaN(this.doubleData[pos]) ? "n/a" : Double.valueOf(this.doubleData[pos]));
            }
            case STRING: {
                return this.stringData[this.intData[pos]];
            }
        }
        if (this.tmpData != null) {
            return this.tmpData.get(pos);
        }
        return null;
    }

    public void copyData(QueryField src) {
        this.fieldType = src.fieldType;
        this.longData = src.longData;
        this.intData = src.intData;
        this.floatData = src.floatData;
        this.doubleData = src.doubleData;
        this.stringData = src.stringData;
        this.stringCounts = src.stringCounts;
        this.legend = src.legend;
    }

    public LegendObject getLegend() {
        if (this.legend == null) {
            this.legend = LegendBuilder.build(this);
        }
        return this.legend;
    }

    public void setLegend(LegendObject legend) {
        this.legend = legend;
    }

    public int getColour(int i) {
        this.getLegend();
        switch (this.fieldType) {
            case INT: {
                return this.legend.getColour(this.intData[i] == Integer.MIN_VALUE ? Float.NaN : (float)this.intData[i]);
            }
            case LONG: {
                return this.legend.getColour(this.longData[i] == Long.MIN_VALUE ? Float.NaN : (float)this.longData[i]);
            }
            case FLOAT: {
                return this.legend.getColour(Float.isNaN(this.floatData[i]) ? Float.NaN : this.floatData[i]);
            }
            case DOUBLE: {
                return this.legend.getColour((float)this.doubleData[i]);
            }
            case STRING: {
                return this.legend.getColour(this.stringData[this.intData[i]]);
            }
        }
        return 0xFFFFFF;
    }

    public int getColourForValue(float value) {
        if (this.fieldType == FieldType.STRING) {
            return this.legend.getColour(String.valueOf(value));
        }
        if (this.legend.numericLegend != null) {
            return this.legend.getColour(value);
        }
        return 0xFFFFFF;
    }

    public boolean isStore() {
        return this.store;
    }

    public void setStore(boolean store) {
        this.store = store;
    }

    public ArrayList<String> getTmpData() {
        return this.tmpData;
    }

    public void setTmpData(ArrayList<String> tmpData) {
        this.tmpData = tmpData;
    }

    public long[] getLongData() {
        return this.longData;
    }

    public void setLongData(long[] longData) {
        this.longData = longData;
    }

    public int[] getIntData() {
        return this.intData;
    }

    public void setIntData(int[] intData) {
        this.intData = intData;
    }

    public String[] getStringData() {
        return this.stringData;
    }

    public void setStringData(String[] stringData) {
        this.stringData = stringData;
    }

    public float[] getFloatData() {
        return this.floatData;
    }

    public void setFloatData(float[] floatData) {
        this.floatData = floatData;
    }

    public double[] getDoubleData() {
        return this.doubleData;
    }

    public void setDoubleData(double[] doubleData) {
        this.doubleData = doubleData;
    }

    public int[] getStringCounts() {
        return this.stringCounts;
    }

    public void setStringCounts(int[] stringCounts) {
        this.stringCounts = stringCounts;
    }

    public static class QueryFieldComparator
    implements Comparator<QueryField> {
        @Override
        public int compare(QueryField qf1, QueryField qf2) {
            if (qf1.group == null || qf2.group == null) {
                return 0;
            }
            return qf1.group.getOrder().compareTo(qf2.group.getOrder());
        }
    }

    public static enum GroupType {
        TAXONOMIC("Taxonomic", 1),
        GEOSPATIAL("Geospatial", 2),
        TEMPORAL("Temporal", 3),
        RECORD_DETAILS("Record details", 4),
        ATTRIBUTION("Attribution", 5),
        RECORD_ASSERTIONS("Record assertions", 6),
        CUSTOM("Custom", 0);

        private static final Map<String, GroupType> nameLookup;
        private String name;
        private Integer order;

        private GroupType(String name, Integer order) {
            this.name = name;
            this.order = order;
        }

        public static GroupType getGroupType(String group) {
            return nameLookup.get(group);
        }

        public static GroupType fromString(String value) {
            for (GroupType gt : GroupType.values()) {
                if (!gt.name().equalsIgnoreCase(value)) continue;
                return gt;
            }
            return CUSTOM;
        }

        public Integer getOrder() {
            return this.order;
        }

        public String getName() {
            return this.name;
        }

        static {
            nameLookup = new HashMap<String, GroupType>();
            for (GroupType mt : EnumSet.allOf(GroupType.class)) {
                nameLookup.put(mt.name, mt);
            }
        }
    }

    public static enum FieldType {
        LONG,
        INT,
        STRING,
        FLOAT,
        DOUBLE,
        AUTO;


        public static FieldType fromString(String value) {
            for (FieldType ft : FieldType.values()) {
                if (!ft.name().equalsIgnoreCase(value)) continue;
                return ft;
            }
            return AUTO;
        }
    }
}

