/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops.spring;

import java.util.Arrays;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.OperandPolicy;
import org.scale7.cassandra.pelops.pool.CommonsBackedPool;
import org.scale7.cassandra.pelops.pool.IThriftPool;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class CommonsBackedPoolFactoryBean
implements FactoryBean<IThriftPool>,
InitializingBean,
DisposableBean {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(CommonsBackedPoolFactoryBean.class);
    private Cluster cluster;
    private String keyspace;
    private CommonsBackedPool.Policy policy;
    private OperandPolicy operandPolicy;
    private CommonsBackedPool.INodeSelectionStrategy nodeSelectionStrategy;
    private CommonsBackedPool.INodeSuspensionStrategy nodeSuspensionStrategy;
    private CommonsBackedPool.IConnectionValidator connectionValidator;
    private IThriftPool thriftPool;

    public IThriftPool getObject() throws Exception {
        return this.thriftPool;
    }

    public Class<?> getObjectType() {
        return IThriftPool.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getCluster(), (String)"The cluster property is required");
        Assert.notNull((Object)this.getKeyspace(), (String)"The keyspace property is required");
        logger.info("Initializing Pelops pool keyspace {} for nodes {}", (Object)this.getKeyspace(), (Object)Arrays.toString(this.getCluster().getNodes()));
        this.thriftPool = new CommonsBackedPool(this.getCluster(), this.getKeyspace(), this.getPolicy(), this.getOperandPolicy(), this.getNodeSelectionStrategy(), this.getNodeSuspensionStrategy(), this.getConnectionValidator());
    }

    public void destroy() throws Exception {
        this.thriftPool.shutdown();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    @Required
    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    @Required
    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public CommonsBackedPool.Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(CommonsBackedPool.Policy policy) {
        this.policy = policy;
    }

    public OperandPolicy getOperandPolicy() {
        return this.operandPolicy;
    }

    public void setOperandPolicy(OperandPolicy operandPolicy) {
        this.operandPolicy = operandPolicy;
    }

    public CommonsBackedPool.INodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    public void setNodeSelectionStrategy(CommonsBackedPool.INodeSelectionStrategy nodeSelectionStrategy) {
        this.nodeSelectionStrategy = nodeSelectionStrategy;
    }

    public CommonsBackedPool.INodeSuspensionStrategy getNodeSuspensionStrategy() {
        return this.nodeSuspensionStrategy;
    }

    public void setNodeSuspensionStrategy(CommonsBackedPool.INodeSuspensionStrategy nodeSuspensionStrategy) {
        this.nodeSuspensionStrategy = nodeSuspensionStrategy;
    }

    public CommonsBackedPool.IConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    public void setConnectionValidator(CommonsBackedPool.IConnectionValidator connectionValidator) {
        this.connectionValidator = connectionValidator;
    }
}

