/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SuperColumn;
import org.scale7.cassandra.pelops.Bytes;
import org.scale7.cassandra.pelops.Operand;
import org.scale7.cassandra.pelops.OperandPolicy;
import org.scale7.cassandra.pelops.Validation;
import org.scale7.cassandra.pelops.exceptions.PelopsException;
import org.scale7.cassandra.pelops.pool.IThriftPool;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class Mutator
extends Operand {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(Mutator.class);
    public static final int NO_TTL = -1;
    private final Map<ByteBuffer, Map<String, List<Mutation>>> batch;
    protected final long timestamp;
    protected final boolean deleteIfNull;
    protected final int ttl;

    public void execute(ConsistencyLevel cLevel) throws PelopsException {
        this.execute(cLevel, this.thrift.getOperandPolicy());
    }

    public void execute(ConsistencyLevel cLevel, int maxOpRetries) throws PelopsException {
        OperandPolicy operandPolicy = this.thrift.getOperandPolicy().copy().setMaxOpRetries(maxOpRetries);
        this.execute(cLevel, operandPolicy);
    }

    public void execute(final ConsistencyLevel cLevel, OperandPolicy operandPolicy) throws PelopsException {
        Operand.IOperation<Void> operation = new Operand.IOperation<Void>(){

            @Override
            public Void execute(IThriftPool.IPooledConnection conn) throws Exception {
                conn.getAPI().batch_mutate(Mutator.this.batch, cLevel);
                return null;
            }
        };
        this.tryOperation(operation, operandPolicy);
    }

    public Mutator writeColumn(String colFamily, String rowKey, Column column) {
        this.writeColumn(colFamily, Bytes.fromUTF8(rowKey), column);
        return this;
    }

    public Mutator writeColumn(String colFamily, Bytes rowKey, Column column) {
        this.writeColumn(colFamily, rowKey, column, this.deleteIfNull);
        return this;
    }

    public Mutator writeColumn(String colFamily, Bytes rowKey, Column column, boolean deleteIfNullValue) {
        if (!deleteIfNullValue || column.isSetValue()) {
            this.writeColumnInternal(colFamily, rowKey, column);
        } else {
            this.deleteColumn(colFamily, rowKey, Bytes.fromByteArray(column.getName()));
        }
        return this;
    }

    private void writeColumnInternal(String colFamily, Bytes rowKey, Column column) {
        Validation.safeGetRowKey(rowKey);
        Validation.validateColumn(column);
        ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
        cosc.setColumn(column);
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(cosc);
        this.getMutationList(colFamily, rowKey).add(mutation);
    }

    public Mutator writeColumns(String colFamily, String rowKey, List<Column> columns) {
        this.writeColumns(colFamily, Bytes.fromUTF8(rowKey), columns);
        return this;
    }

    public Mutator writeColumns(String colFamily, Bytes rowKey, List<Column> columns) {
        for (Column column : columns) {
            this.writeColumn(colFamily, rowKey, column);
        }
        return this;
    }

    public Mutator writeColumns(String colFamily, Bytes rowKey, List<Column> columns, boolean deleteIfNullValue) {
        for (Column column : columns) {
            this.writeColumn(colFamily, rowKey, column, deleteIfNullValue);
        }
        return this;
    }

    public Mutator writeSubColumn(String colFamily, String rowKey, String colName, Column subColumn) {
        this.writeSubColumn(colFamily, rowKey, Bytes.fromUTF8(colName), subColumn);
        return this;
    }

    public Mutator writeSubColumn(String colFamily, String rowKey, Bytes colName, Column subColumn) {
        this.writeSubColumn(colFamily, Bytes.fromUTF8(rowKey), colName, subColumn);
        return this;
    }

    public Mutator writeSubColumn(String colFamily, Bytes rowKey, Bytes colName, Column subColumn) {
        this.writeSubColumns(colFamily, rowKey, colName, Arrays.asList(subColumn));
        return this;
    }

    public Mutator writeSubColumns(String colFamily, String rowKey, String colName, List<Column> subColumns) {
        this.writeSubColumns(colFamily, rowKey, Bytes.fromUTF8(colName), subColumns);
        return this;
    }

    public Mutator writeSubColumns(String colFamily, String rowKey, Bytes colName, List<Column> subColumns) {
        this.writeSubColumns(colFamily, Bytes.fromUTF8(rowKey), colName, subColumns);
        return this;
    }

    public Mutator writeSubColumns(String colFamily, Bytes rowKey, Bytes colName, List<Column> subColumns) {
        this.writeSubColumns(colFamily, rowKey, colName, subColumns, this.deleteIfNull);
        return this;
    }

    public Mutator writeSubColumns(String colFamily, Bytes rowKey, Bytes colName, List<Column> subColumns, boolean deleteIfNullValue) {
        if (deleteIfNullValue) {
            boolean isEmptyColumnPresent = false;
            for (Column subColumn : subColumns) {
                if (subColumn.isSetValue()) continue;
                isEmptyColumnPresent = true;
                break;
            }
            if (isEmptyColumnPresent) {
                ArrayList<Column> subColumnsWithValue = new ArrayList<Column>(subColumns.size());
                ArrayList<Bytes> subColumnsWithoutValue = new ArrayList<Bytes>(subColumns.size());
                for (Column subColumn : subColumns) {
                    if (subColumn.isSetValue()) {
                        subColumnsWithValue.add(subColumn);
                        continue;
                    }
                    subColumnsWithoutValue.add(Bytes.fromByteArray(subColumn.getName()));
                }
                this.deleteSubColumns(colFamily, rowKey, colName, subColumnsWithoutValue);
                subColumns = subColumnsWithValue;
            }
        }
        this.writeSubColumnsInternal(colFamily, rowKey, colName, subColumns);
        return this;
    }

    private void writeSubColumnsInternal(String colFamily, Bytes rowKey, Bytes colName, List<Column> subColumns) {
        Validation.safeGetRowKey(rowKey);
        Validation.validateColumnName(colName);
        Validation.validateColumns(subColumns);
        SuperColumn scol = new SuperColumn(Bytes.nullSafeGet(colName), subColumns);
        ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
        cosc.setSuper_column(scol);
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(cosc);
        this.getMutationList(colFamily, rowKey).add(mutation);
    }

    public Mutator writeCounterColumns(String colFamily, String rowKey, List<CounterColumn> columns) {
        return this.writeCounterColumns(colFamily, Bytes.fromUTF8(rowKey), columns);
    }

    public Mutator writeCounterColumns(String colFamily, Bytes rowKey, List<CounterColumn> columns) {
        for (CounterColumn column : columns) {
            this.writeCounterColumn(colFamily, rowKey, column);
        }
        return this;
    }

    public Mutator writeCounterColumn(String colFamily, String rowKey, String colName, long value) {
        return this.writeCounterColumn(colFamily, Bytes.fromUTF8(rowKey), this.newCounterColumn(colName, value));
    }

    public Mutator writeCounterColumn(String colFamily, String rowKey, Bytes colName, long value) {
        return this.writeCounterColumn(colFamily, Bytes.fromUTF8(rowKey), this.newCounterColumn(colName, value));
    }

    public Mutator writeCounterColumn(String colFamily, Bytes rowKey, Bytes colName, long value) {
        return this.writeCounterColumn(colFamily, rowKey, this.newCounterColumn(colName, value));
    }

    public Mutator writeCounterColumn(String colFamily, Bytes rowKey, CounterColumn column) {
        Validation.safeGetRowKey(rowKey);
        Validation.validateColumn(column);
        ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
        cosc.setCounter_column(column);
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(cosc);
        this.getMutationList(colFamily, rowKey).add(mutation);
        return this;
    }

    public Mutator writeSubCounterColumn(String colFamily, String rowKey, String colName, CounterColumn subColumn) {
        return this.writeSubCounterColumn(colFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(colName), subColumn);
    }

    public Mutator writeSubCounterColumn(String colFamily, String rowKey, Bytes colName, CounterColumn subColumn) {
        return this.writeSubCounterColumn(colFamily, Bytes.fromUTF8(rowKey), colName, subColumn);
    }

    public Mutator writeSubCounterColumn(String colFamily, Bytes rowKey, Bytes colName, CounterColumn subColumn) {
        this.writeSubCounterColumns(colFamily, rowKey, colName, Arrays.asList(subColumn));
        return this;
    }

    public Mutator writeSubCounterColumns(String colFamily, Bytes rowKey, Bytes colName, List<CounterColumn> subColumns) {
        Validation.safeGetRowKey(rowKey);
        Validation.validateColumnName(colName);
        Validation.validateCounterColumns(subColumns);
        CounterSuperColumn scol = new CounterSuperColumn(Bytes.nullSafeGet(colName), subColumns);
        ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
        cosc.setCounter_super_column(scol);
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(cosc);
        this.getMutationList(colFamily, rowKey).add(mutation);
        return this;
    }

    public Mutator deleteColumn(String colFamily, String rowKey, String colName) {
        this.deleteColumn(colFamily, rowKey, Bytes.fromUTF8(colName));
        return this;
    }

    public Mutator deleteColumn(String colFamily, String rowKey, Bytes colName) {
        this.deleteColumn(colFamily, Bytes.fromUTF8(rowKey), colName);
        return this;
    }

    public Mutator deleteColumn(String colFamily, Bytes rowKey, Bytes colName) {
        this.deleteColumns(colFamily, rowKey, Arrays.asList(colName));
        return this;
    }

    public Mutator deleteColumns(String colFamily, String rowKey, Bytes ... colNames) {
        this.deleteColumns(colFamily, Bytes.fromUTF8(rowKey), Arrays.asList(colNames));
        return this;
    }

    public Mutator deleteColumns(String colFamily, Bytes rowKey, Bytes ... colNames) {
        this.deleteColumns(colFamily, rowKey, Arrays.asList(colNames));
        return this;
    }

    public Mutator deleteColumns(String colFamily, String rowKey, String ... colNames) {
        ArrayList<Bytes> colNameList = new ArrayList<Bytes>(colNames.length);
        for (String colName : colNames) {
            colNameList.add(Bytes.fromUTF8(colName));
        }
        this.deleteColumns(colFamily, Bytes.fromUTF8(rowKey), colNameList);
        return this;
    }

    public Mutator deleteColumns(String colFamily, String rowKey, List<Bytes> colNames) {
        this.deleteColumns(colFamily, Bytes.fromUTF8(rowKey), colNames);
        return this;
    }

    public Mutator deleteColumns(String colFamily, Bytes rowKey, List<Bytes> colNames) {
        Validation.safeGetRowKey(rowKey);
        Validation.validateColumnNames(colNames);
        SlicePredicate pred = new SlicePredicate();
        pred.setColumn_names(Bytes.transformBytesToList(colNames));
        Deletion deletion = new Deletion();
        deletion.setTimestamp(this.timestamp);
        deletion.setPredicate(pred);
        Mutation mutation = new Mutation();
        mutation.setDeletion(deletion);
        this.getMutationList(colFamily, rowKey).add(mutation);
        return this;
    }

    public Mutator deleteSubColumn(String colFamily, String rowKey, String colName, String subColName) {
        this.deleteSubColumn(colFamily, rowKey, Bytes.fromUTF8(colName), Bytes.fromUTF8(subColName));
        return this;
    }

    public Mutator deleteSubColumn(String colFamily, String rowKey, Bytes colName, String subColName) {
        this.deleteSubColumn(colFamily, rowKey, colName, Bytes.fromUTF8(subColName));
        return this;
    }

    public Mutator deleteSubColumn(String colFamily, String rowKey, String colName, Bytes subColName) {
        this.deleteSubColumn(colFamily, rowKey, Bytes.fromUTF8(colName), subColName);
        return this;
    }

    public Mutator deleteSubColumn(String colFamily, String rowKey, Bytes colName, Bytes subColName) {
        this.deleteSubColumn(colFamily, Bytes.fromUTF8(rowKey), colName, subColName);
        return this;
    }

    public Mutator deleteSubColumn(String colFamily, Bytes rowKey, Bytes colName, Bytes subColName) {
        ArrayList<Bytes> subColNames = new ArrayList<Bytes>(1);
        subColNames.add(subColName);
        this.deleteSubColumns(colFamily, rowKey, colName, subColNames);
        return this;
    }

    public Mutator deleteSubColumns(String colFamily, String rowKey, String colName, String ... subColNames) {
        this.deleteSubColumns(colFamily, rowKey, Bytes.fromUTF8(colName), subColNames);
        return this;
    }

    public Mutator deleteSubColumns(String colFamily, String rowKey, Bytes colName, String ... subColNames) {
        this.deleteSubColumns(colFamily, Bytes.fromUTF8(rowKey), colName, subColNames);
        return this;
    }

    public Mutator deleteSubColumns(String colFamily, Bytes rowKey, Bytes colName, String ... subColNames) {
        ArrayList<Bytes> subColNamesList = new ArrayList<Bytes>(subColNames.length);
        for (String subColName : subColNames) {
            subColNamesList.add(Bytes.fromUTF8(subColName));
        }
        this.deleteSubColumns(colFamily, rowKey, colName, subColNamesList);
        return this;
    }

    public Mutator deleteSubColumns(String colFamily, String rowKey, String colName) {
        this.deleteSubColumns(colFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(colName), (List<Bytes>)null);
        return this;
    }

    public Mutator deleteSubColumns(String colFamily, String rowKey, String colName, List<Bytes> subColNames) {
        this.deleteSubColumns(colFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(colName), subColNames);
        return this;
    }

    public Mutator deleteSubColumns(String colFamily, String rowKey, Bytes colName) {
        this.deleteSubColumns(colFamily, Bytes.fromUTF8(rowKey), colName, (List<Bytes>)null);
        return this;
    }

    public Mutator deleteSubColumns(String colFamily, String rowKey, Bytes colName, List<Bytes> subColNames) {
        this.deleteSubColumns(colFamily, Bytes.fromUTF8(rowKey), colName, subColNames);
        return this;
    }

    public Mutator deleteSubColumns(String colFamily, Bytes rowKey, Bytes colName, List<Bytes> subColNames) {
        Validation.safeGetRowKey(rowKey);
        Validation.validateColumnName(colName);
        Validation.validateColumnNames(subColNames);
        Deletion deletion = new Deletion();
        deletion.setTimestamp(this.timestamp);
        deletion.setSuper_column(Bytes.nullSafeGet(colName));
        deletion.setPredicate(subColNames != null && !subColNames.isEmpty() ? new SlicePredicate().setColumn_names(Bytes.transformBytesToList(subColNames)) : null);
        Mutation mutation = new Mutation();
        mutation.setDeletion(deletion);
        this.getMutationList(colFamily, rowKey).add(mutation);
        return this;
    }

    public Column newColumn(String colName, String colValue) {
        return this.newColumn(Bytes.fromUTF8(colName), Bytes.fromUTF8(colValue));
    }

    public Column newColumn(String colName, String colValue, int ttl) {
        return this.newColumn(Bytes.fromUTF8(colName), Bytes.fromUTF8(colValue), ttl);
    }

    public Column newColumn(Bytes colName, String colValue) {
        return this.newColumn(colName, Bytes.fromUTF8(colValue));
    }

    public Column newColumn(Bytes colName, String colValue, int ttl) {
        return this.newColumn(colName, Bytes.fromUTF8(colValue), ttl);
    }

    public Column newColumn(String colName) {
        return this.newColumn(Bytes.fromUTF8(colName), Bytes.EMPTY);
    }

    public Column newColumn(String colName, Bytes colValue) {
        return this.newColumn(Bytes.fromUTF8(colName), colValue);
    }

    public Column newColumn(String colName, int ttl) {
        return this.newColumn(Bytes.fromUTF8(colName), Bytes.EMPTY, ttl);
    }

    public Column newColumn(String colName, Bytes colValue, int ttl) {
        return this.newColumn(Bytes.fromUTF8(colName), colValue, ttl);
    }

    public Column newColumn(Bytes colName) {
        return this.newColumn(colName, Bytes.EMPTY);
    }

    public Column newColumn(Bytes colName, Bytes colValue) {
        return this.newColumn(colName, colValue, this.ttl);
    }

    public Column newColumn(Bytes colName, int ttl) {
        return this.newColumn(colName, Bytes.EMPTY, ttl);
    }

    public Column newColumn(Bytes colName, Bytes colValue, int ttl) {
        Column column = new Column(Bytes.nullSafeGet(colName));
        column.setValue(Bytes.nullSafeGet(colValue));
        column.setTimestamp(this.timestamp);
        if (ttl != -1) {
            column.setTtl(ttl);
        }
        return column;
    }

    public List<Column> newColumnList(Column ... columns) {
        ArrayList<Column> list = new ArrayList<Column>(columns.length);
        for (Column column : columns) {
            list.add(column);
        }
        return list;
    }

    public CounterColumn newCounterColumn(String colName, long value) {
        return this.newCounterColumn(Bytes.fromUTF8(colName), value);
    }

    public CounterColumn newCounterColumn(Bytes colName, long value) {
        return new CounterColumn(colName.getBytes(), value);
    }

    public Bytes getMutationTimestamp(boolean microsToMillis) {
        long result = this.timestamp;
        if (microsToMillis) {
            result /= 1000L;
        }
        return Bytes.fromLong(result);
    }

    public long getMutationTimestampValue() {
        return this.timestamp;
    }

    public Mutator(IThriftPool thrift) {
        this(thrift, System.currentTimeMillis() * 1000L, thrift.getOperandPolicy().isDeleteIfNull());
    }

    public Mutator(IThriftPool thrift, long timestamp, boolean deleteIfNull) {
        this(thrift, timestamp, deleteIfNull, -1);
    }

    public Mutator(IThriftPool thrift, long timestamp, boolean deleteIfNull, int ttl) {
        super(thrift);
        this.timestamp = timestamp;
        this.deleteIfNull = deleteIfNull;
        this.ttl = ttl;
        this.batch = new MutationsByKey();
    }

    protected Map<ByteBuffer, Map<String, List<Mutation>>> getBatch() {
        return this.batch;
    }

    protected MutationList getMutationList(String colFamily, Bytes key) {
        MutationList mutList;
        ByteBuffer keyBuffer = key.getBytes();
        MutationsByCf mutsByCf = (MutationsByCf)this.batch.get(keyBuffer);
        if (mutsByCf == null) {
            mutsByCf = new MutationsByCf();
            this.batch.put(keyBuffer, mutsByCf);
        }
        if ((mutList = (MutationList)mutsByCf.get(colFamily)) == null) {
            mutList = new MutationList();
            mutsByCf.put(colFamily, mutList);
        }
        return mutList;
    }

    class MutationsByKey
    extends HashMap<ByteBuffer, Map<String, List<Mutation>>> {
        MutationsByKey() {
        }
    }

    class MutationsByCf
    extends HashMap<String, List<Mutation>> {
        MutationsByCf() {
        }
    }

    class MutationList
    extends ArrayList<Mutation> {
        MutationList() {
        }
    }
}

