/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001u3Q!\u0001\u0002\u0001\u0005\u0019\u0011A\u0002V3tiJ+'/\u001e8oKJT!a\u0001\u0003\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\u0003\u0002\u0007=\u0014xm\u0005\u0003\u0001\u000f=\u0019\u0002C\u0001\u0005\u000e\u001b\u0005I!B\u0001\u0006\f\u0003\u0011a\u0017M\\4\u000b\u00031\tAA[1wC&\u0011a\"\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005A\tR\"\u0001\u0002\n\u0005I\u0011!\u0001\u0003*feVtg.\u001a:\u0011\u0005Q9R\"A\u000b\u000b\u0005YY\u0011AA5p\u0013\tARC\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u00039\u0019X/\u001b;f\u00072\f7o\u001d(b[\u0016\u001c\u0001\u0001\u0005\u0002\u001eG9\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\u00051\u0001K]3eK\u001aL!\u0001J\u0013\u0003\rM#(/\u001b8h\u0015\t\u0011s\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003\u001d\u0003!!Xm\u001d;OC6,\u0007\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0002,Y5\u0002\"\u0001\u0005\u0001\t\u000biA\u0003\u0019\u0001\u000f\t\u000b\u001dB\u0003\u0019\u0001\u000f\t\u000b=\u0002A\u0011\u0001\u0019\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011E\"\u0014HP\"L'b\u0003\"A\b\u001a\n\u0005Mz\"\u0001B+oSRDQ!\u000e\u0018A\u0002Y\naA]3q_J$\bC\u0001\t8\u0013\tA$A\u0001\u0005SKB|'\u000f^3s\u0011\u0015Qd\u00061\u0001<\u0003\u001d\u0019Ho\u001c9qKJ\u0004\"\u0001\u0005\u001f\n\u0005u\u0012!aB*u_B\u0004XM\u001d\u0005\u0006\u007f9\u0002\r\u0001Q\u0001\u0007M&dG/\u001a:\u0011\u0005A\t\u0015B\u0001\"\u0003\u0005\u00191\u0015\u000e\u001c;fe\")AI\fa\u0001\u000b\u0006I1m\u001c8gS\u001el\u0015\r\u001d\t\u0005;\u0019c\u0002*\u0003\u0002HK\t\u0019Q*\u00199\u0011\u0005yI\u0015B\u0001& \u0005\r\te.\u001f\u0005\u0006\u0019:\u0002\r!T\u0001\fI&\u001cHO]5ckR|'\u000fE\u0002\u001f\u001dBK!aT\u0010\u0003\r=\u0003H/[8o!\t\u0001\u0012+\u0003\u0002S\u0005\tYA)[:ue&\u0014W\u000f^8s\u0011\u0015!f\u00061\u0001V\u0003\u001d!(/Y2lKJ\u0004\"\u0001\u0005,\n\u0005]\u0013!a\u0002+sC\u000e\\WM\u001d\u0005\u00063:\u0002\rAW\u0001\u0007Y>\fG-\u001a:\u0011\u0005!Y\u0016B\u0001/\n\u0005-\u0019E.Y:t\u0019>\fG-\u001a:")
public class TestRerunner
implements Rerunner,
Serializable {
    private final String suiteClassName;
    private final String testName;

    @Override
    public void apply(Reporter report, Stopper stopper, Filter filter2, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker, ClassLoader loader) {
        long runStartTime = System.currentTimeMillis();
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            report.apply(RunStarting$.MODULE$.apply(tracker.nextOrdinal(), 1, configMap));
            suite.run((Option<String>)new Some((Object)this.testName), report, stopper, filter2, configMap, distributor, tracker);
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunCompleted$.MODULE$.apply(tracker.nextOrdinal(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.bigProblems(throwable), (Option<Throwable>)new Some((Object)throwable), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadClass", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noClassDefFoundError.getMessage()})), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (SecurityException securityException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("securityWhenRerruning", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{securityException.getMessage()})), (Option<Throwable>)new Some((Object)securityException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotFindMethod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noSuchMethodException.getMessage()})), (Option<Throwable>)new Some((Object)noSuchMethodException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (IllegalAccessException illegalAccessException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{illegalAccessException.getMessage()})), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (InstantiationException instantiationException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{instantiationException.getMessage()})), (Option<Throwable>)new Some((Object)instantiationException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (ClassNotFoundException classNotFoundException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{classNotFoundException.getMessage()})), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
    }

    public TestRerunner(String suiteClassName, String testName) {
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        if (suiteClassName == null || testName == null) {
            throw new NullPointerException();
        }
    }
}

