/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.applets;

import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletClassLoader
extends ClassLoader {
    private static final Log logger_ = LogFactory.getLog(AppletClassLoader.class);
    private final Set<String> definedClasses_ = new HashSet<String>();
    private final Map<String, JarFile> jarFiles_ = new HashMap<String, JarFile>();

    public AppletClassLoader() {
        super(AppletClassLoader.class.getClassLoader());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!this.definedClasses_.contains(name) && this.jarFiles_.containsKey(name)) {
            this.defineClass(name);
        }
        return super.loadClass(name);
    }

    private void defineClass(String name) {
        logger_.debug((Object)("Defining class " + name));
        String classFileName = name.replace('.', '/') + ".class";
        JarFile jarFile = this.jarFiles_.get(name);
        try {
            InputStream is = jarFile.getInputStream(jarFile.getEntry(classFileName));
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            this.defineClass(name, bytes, 0, bytes.length);
            this.definedClasses_.add(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addToClassPath(WebResponse webResponse) throws IOException {
        this.readClassesFromJar(webResponse);
    }

    private void readClassesFromJar(WebResponse webResponse) throws IOException {
        File tmpFile = File.createTempFile("HtmlUnit", "jar");
        tmpFile.deleteOnExit();
        FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])webResponse.getContentAsBytes());
        JarFile jarFile = new JarFile(tmpFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            String className = name.replace('/', '.').substring(0, name.length() - 6);
            this.jarFiles_.put(className, jarFile);
            logger_.trace((Object)("Jar entry: " + className));
        }
    }

    public static String readClassName(WebResponse webResponse) {
        return AppletClassLoader.readClassName(webResponse.getContentAsBytes());
    }

    public static String readClassName(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 16;
        byte b = bytes[16];
        while (b != 7) {
            sb.append((char)b);
            b = bytes[++i];
        }
        return sb.toString().replace('/', '.');
    }
}

