/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class TableCell
extends TableFObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private LengthRangeProperty blockProgressionDimension;
    private int columnNumber;
    private int displayAlign;
    private int emptyCells;
    private int endsRow;
    private int numberColumnsSpanned;
    private int numberRowsSpanned;
    private int startsRow;
    private Length width;
    private boolean blockItemFound = false;

    public TableCell(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.displayAlign = pList.get(81).getEnum();
        this.emptyCells = pList.get(84).getEnum();
        this.endsRow = pList.get(86).getEnum();
        this.columnNumber = pList.get(70).getNumeric().getValue();
        this.numberColumnsSpanned = pList.get(149).getNumeric().getValue();
        this.numberRowsSpanned = pList.get(150).getNumeric().getValue();
        this.startsRow = pList.get(213).getEnum();
        this.width = pList.get(242).getLength();
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startCell(this);
    }

    protected void endOfNode() throws FOPException {
        if (!this.blockItemFound) {
            if (this.getUserAgent().validateStrictly()) {
                this.missingChildElementError("marker* (%block;)+");
            } else if (this.firstChild != null) {
                log.warn((Object)"fo:table-cell content that is not enclosed by a fo:block will be dropped/ignored.");
            }
        }
        if ((this.startsRow() || this.endsRow()) && this.getParent().getNameId() == 54) {
            log.warn((Object)"starts-row/ends-row for fo:table-cells non-applicable for children of an fo:table-row.");
        }
        this.getFOEventHandler().endCell(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && localName.equals("marker")) {
            if (this.blockItemFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "(%block;)");
            }
        } else if (!this.isBlockItem(nsURI, localName)) {
            this.invalidChildError(loc, nsURI, localName);
        } else {
            this.blockItemFound = true;
        }
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean showEmptyCells() {
        return this.emptyCells == 130;
    }

    public int getNumberColumnsSpanned() {
        return Math.max(this.numberColumnsSpanned, 1);
    }

    public int getNumberRowsSpanned() {
        return Math.max(this.numberRowsSpanned, 1);
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public int getDisplayAlign() {
        return this.displayAlign;
    }

    public Length getWidth() {
        return this.width;
    }

    public boolean startsRow() {
        return this.startsRow == 149;
    }

    public boolean endsRow() {
        return this.endsRow == 149;
    }

    public String getLocalName() {
        return "table-cell";
    }

    public final int getNameId() {
        return 50;
    }
}

