/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gbif.dwc.ArchiveFile;
import org.gbif.dwc.DwcLayout;
import org.gbif.dwc.MetadataException;
import org.gbif.dwc.StarRecordIterator;
import org.gbif.dwc.UnsupportedArchiveException;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.record.StarRecord;
import org.gbif.dwc.terms.Term;
import org.gbif.dwcaio.shaded.com.google.common.collect.Maps;
import org.gbif.utils.file.ClosableIterator;
import org.gbif.utils.file.FileUtils;
import org.gbif.utils.file.InputStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Archive
implements Iterable<StarRecord> {
    public static final String CONSTITUENT_DIR = "dataset";
    public static final String META_FN = "meta.xml";
    private static final Logger LOG = LoggerFactory.getLogger(Archive.class);
    private String metadataLocation;
    private String metadata;
    private File location;
    private ArchiveFile core;
    private Set<ArchiveFile> extensions = new HashSet<ArchiveFile>();
    private DwcLayout dwcLayout;
    private boolean normalizedAndSorted = false;

    public void addExtension(ArchiveFile extension) {
        extension.setArchive(this);
        this.extensions.add(extension);
    }

    public ArchiveFile getCore() {
        return this.core;
    }

    public ArchiveFile getExtension(Term rowType) {
        for (ArchiveFile af : this.extensions) {
            if (af.getRowType() == null || !af.getRowType().equals(rowType)) continue;
            return af;
        }
        return null;
    }

    public Set<ArchiveFile> getExtensions() {
        return this.extensions;
    }

    public File getLocation() {
        return this.location;
    }

    public String getMetadata() throws MetadataException {
        if (this.metadata == null) {
            File mf = this.getMetadataLocationFile();
            try {
                InputStream stream;
                if (mf.exists()) {
                    stream = FileUtils.getInputStream((File)mf);
                } else {
                    URL url = new URL(this.metadataLocation);
                    stream = url.openStream();
                }
                this.metadata = new InputStreamUtils().readEntireStream(stream, FileUtils.UTF8);
            }
            catch (IOException e) {
                throw new MetadataException(e);
            }
            catch (RuntimeException e) {
                throw new MetadataException(e);
            }
        }
        return this.metadata;
    }

    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    public File getMetadataLocationFile() {
        if (this.metadataLocation != null) {
            return new File(this.location, this.metadataLocation);
        }
        return null;
    }

    public Map<String, File> getConstituentMetadata() {
        File[] files;
        HashMap<String, File> constituents = Maps.newHashMap();
        File constDir = new File(this.location, CONSTITUENT_DIR);
        if (constDir.exists() && (files = constDir.listFiles((dir, filename) -> filename.endsWith(".xml"))) != null) {
            for (File cf : files) {
                String name = cf.getName().split("\\.")[0];
                constituents.put(name, cf);
            }
        }
        return constituents;
    }

    public void validate() throws UnsupportedArchiveException {
        if (this.core == null) {
            throw new UnsupportedArchiveException("Parts of DwC-A are missing");
        }
        this.core.validateAsCore(!this.extensions.isEmpty());
        LOG.trace("Core is valid");
        for (ArchiveFile af : this.extensions) {
            af.validateAsExtension();
            LOG.trace("Extension {} is valid", (Object)af);
        }
        LOG.debug("Archive contains {} described extension files", (Object)this.extensions.size());
        LOG.debug("Archive contains {} core properties", (Object)this.core.getFields().size());
    }

    public void initialize() throws IOException {
        if (this.normalizedAndSorted) {
            return;
        }
        Objects.requireNonNull(this.getCore(), "The archive shall have a core");
        if (this.getExtensions().isEmpty()) {
            LOG.debug("Archive has no extensions, so initialization is unnecessary.");
            this.normalizedAndSorted = true;
            return;
        }
        LOG.info("Initializing Darwin Core Archive for iteration. This can take some minutes on large archives.");
        this.getCore().normalizeAndSort();
        for (ArchiveFile archiveFile : this.getExtensions()) {
            archiveFile.normalizeAndSort();
        }
        this.normalizedAndSorted = true;
    }

    @Override
    public ClosableIterator<StarRecord> iterator() {
        return this.iterator(true, true);
    }

    public ClosableIterator<StarRecord> iterator(boolean replaceNulls, boolean replaceEntities) {
        try {
            this.initialize();
            if (this.getExtensions().isEmpty()) {
                return new StarRecordIterator(this.getCore().iterator(replaceNulls, replaceEntities), null);
            }
            return new StarRecordIterator(this.getCore().sortedIterator(replaceNulls, replaceEntities), this.getExtensionIterators(replaceNulls, replaceEntities));
        }
        catch (Exception e) {
            throw new UnsupportedArchiveException(e);
        }
    }

    private Map<Term, ClosableIterator<Record>> getExtensionIterators(boolean replaceNulls, boolean replaceEntities) throws IOException {
        HashMap<Term, ClosableIterator<Record>> extensionIterators = new HashMap<Term, ClosableIterator<Record>>();
        for (ArchiveFile ext : this.getExtensions()) {
            extensionIterators.put(ext.getRowType(), ext.sortedIterator(replaceNulls, replaceEntities));
        }
        return extensionIterators;
    }

    public void setCore(ArchiveFile core) {
        core.setArchive(this);
        this.core = core;
    }

    public void setExtensions(Set<ArchiveFile> extensions) {
        this.extensions = extensions;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public void setMetadataLocation(String metadataLocation) {
        this.metadataLocation = metadataLocation;
    }

    public DwcLayout getDwcLayout() {
        return this.dwcLayout;
    }

    public void setDwcLayout(DwcLayout dwcLayout) {
        this.dwcLayout = dwcLayout;
    }

    public String toString() {
        String result = "";
        result = result + (this.location == null ? "no archive file" : this.location.getAbsoluteFile());
        return result;
    }
}

