/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.strategy;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.validation.constraints.Size;
import org.gbif.crawler.CrawlContext;

public class ScientificNameRangeCrawlContext
extends CrawlContext {
    private static final int MIN_LENGTH = 3;
    @Size(min=3, max=3)
    private Optional<String> lowerBound = Optional.absent();
    @Size(min=3, max=3)
    private Optional<String> upperBound = Optional.of((Object)"Aaa");

    public ScientificNameRangeCrawlContext() {
    }

    public ScientificNameRangeCrawlContext(int offset, @Nullable String lowerBound, @Nullable String upperBound) {
        super(offset);
        this.setUpperBound(upperBound);
        this.setLowerBound(lowerBound);
    }

    public Optional<String> getLowerBound() {
        return this.lowerBound;
    }

    public final void setLowerBound(@Nullable String lowerBound) {
        Preconditions.checkArgument((lowerBound == null || lowerBound.length() == 3 ? 1 : 0) != 0, (Object)"Lower bound needs to be either absent/null or three characters long");
        this.lowerBound = Optional.fromNullable((Object)lowerBound);
    }

    public Optional<String> getUpperBound() {
        return this.upperBound;
    }

    public final void setUpperBound(@Nullable String upperBound) {
        Preconditions.checkArgument((upperBound == null || upperBound.length() == 3 ? 1 : 0) != 0, (Object)"Upper bound needs to be either absent/null or three characters long");
        this.upperBound = Optional.fromNullable((Object)upperBound);
    }

    public void setLowerBoundAbsent() {
        this.lowerBound = Optional.absent();
    }

    public void setUpperBoundAbsent() {
        this.upperBound = Optional.absent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScientificNameRangeCrawlContext other = (ScientificNameRangeCrawlContext)obj;
        return Objects.equal((Object)this.getOffset(), (Object)other.getOffset()) && Objects.equal(this.lowerBound, other.lowerBound) && Objects.equal(this.upperBound, other.upperBound);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getOffset(), this.lowerBound, this.upperBound});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("offset", this.getOffset()).add("lowerBound", this.lowerBound).add("upperBound", this.upperBound).toString();
    }
}

