/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.gbif.crawler.CrawlClient;
import org.gbif.crawler.ResponseHandler;
import org.gbif.crawler.exception.FatalCrawlException;
import org.gbif.crawler.exception.ProtocolException;
import org.gbif.crawler.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class HttpCrawlClient
implements CrawlClient<String, HttpResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCrawlClient.class);
    private final HttpClientConnectionManager connectionManager;
    private final HttpClient httpClient;

    public static HttpCrawlClient newInstance(int connectionTimeout, int maxTotalConnections, int maxTotalPerRoute) {
        Preconditions.checkArgument((connectionTimeout > 0 ? 1 : 0) != 0, (Object)"connectionTimeout has to be greater than zero");
        Preconditions.checkArgument((maxTotalConnections > 0 ? 1 : 0) != 0, (Object)"maxTotalConnections has to be greater than zero");
        Preconditions.checkArgument((maxTotalPerRoute > 0 ? 1 : 0) != 0, (Object)"maxTotalPerRoute has to be greater than zero");
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setMaxTotal(maxTotalConnections);
        connectionManager.setDefaultMaxPerRoute(maxTotalPerRoute);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout).setSocketTimeout(connectionTimeout).build();
        CloseableHttpClient httpClient = HttpClients.custom().setUserAgent("GBIF-Crawler").setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig).build();
        return new HttpCrawlClient((HttpClientConnectionManager)connectionManager, (HttpClient)httpClient);
    }

    public HttpCrawlClient(HttpClientConnectionManager connectionManager, HttpClient httpClient) {
        Preconditions.checkNotNull((Object)connectionManager);
        Preconditions.checkNotNull((Object)httpClient);
        this.connectionManager = connectionManager;
        this.httpClient = httpClient;
    }

    @Override
    public <RESULT> RESULT execute(String request, ResponseHandler<HttpResponse, RESULT> handler) throws FatalCrawlException, TransportException, ProtocolException {
        HttpGet httpget = new HttpGet(request);
        LOG.debug("Executing request [{}]", (Object)request);
        try {
            return (RESULT)this.httpClient.execute((HttpUriRequest)httpget, new ForwardingResponseHandler<RESULT>(handler));
        }
        catch (RuntimeException e) {
            LOG.debug("Caught exception from underlying ResponseHandler", e.getCause());
            Throwables.propagateIfPossible((Throwable)e.getCause(), ProtocolException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), TransportException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), FatalCrawlException.class);
            throw e;
        }
        catch (IOException e) {
            LOG.debug("Caught exception during the HTTP request [{}]", (Object)httpget, (Object)e);
            throw new TransportException(e);
        }
    }

    public void shutdown() {
        this.connectionManager.shutdown();
    }

    @VisibleForTesting
    static class ForwardingResponseHandler<R>
    implements org.apache.http.client.ResponseHandler<R> {
        private final ResponseHandler<HttpResponse, R> handler;

        ForwardingResponseHandler(ResponseHandler<HttpResponse, R> handler) {
            this.handler = handler;
        }

        public R handleResponse(HttpResponse response) throws IOException {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ClientProtocolException("HTTP status code[" + response.getStatusLine().getStatusCode() + "] indicates failure: [" + response.getStatusLine() + "]");
            }
            try {
                return this.handler.handleResponse(response);
            }
            catch (ProtocolException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (TransportException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (FatalCrawlException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

