/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.validation.constraints.Min;

public class CrawlContext {
    @Min(value=0L)
    private int offset;
    private boolean speculative;
    private Optional<Long> lastContentHash = Optional.absent();
    private volatile boolean aborted;

    protected CrawlContext() {
        this.offset = 0;
    }

    protected CrawlContext(int offset) {
        this.setOffset(offset);
    }

    public int getOffset() {
        return this.offset;
    }

    public final void setOffset(int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset has to be greater than or equal to 0");
        this.offset = offset;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void abort() {
        this.aborted = true;
    }

    public boolean isSpeculative() {
        return this.speculative;
    }

    public void setSpeculative(boolean speculative) {
        this.speculative = speculative;
    }

    public Optional<Long> getLastContentHash() {
        return this.lastContentHash;
    }

    public void setLastContentHash(Optional<Long> lastContentHash) {
        this.lastContentHash = (Optional)Preconditions.checkNotNull(lastContentHash, (Object)"lastContentHash can't be null");
    }
}

