/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.renderer.lite.FastBBOX;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;

class AttributeRenameVisitor
extends DuplicatingFilterVisitor {
    String source;
    String target;

    public AttributeRenameVisitor(String source, String target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public Object visit(PropertyName expression, Object extraData) {
        String propertyName = expression.getPropertyName();
        if (propertyName != null && propertyName.equals(this.source)) {
            return this.getFactory(extraData).property(this.target);
        }
        return super.visit(expression, extraData);
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        PropertyName pname;
        String name;
        Expression e1 = filter.getExpression1();
        if (e1 instanceof PropertyName && (name = (pname = (PropertyName)e1).getPropertyName()) != null && name.equals(this.source)) {
            e1 = this.ff.property(this.target);
        }
        if (filter instanceof FastBBOX && e1 instanceof PropertyName) {
            FastBBOX fbox = (FastBBOX)filter;
            return new FastBBOX((PropertyName)e1, fbox.getEnvelope(), (FilterFactory)this.getFactory(extraData));
        }
        double minx = filter.getMinX();
        double miny = filter.getMinY();
        double maxx = filter.getMaxX();
        double maxy = filter.getMaxY();
        String srs = filter.getSRS();
        return this.getFactory(extraData).bbox(e1, minx, miny, maxx, maxy, srs);
    }
}

