/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file.tabular;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.gbif.common.shaded.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.gbif.common.shaded.com.google.common.base.Preconditions;
import org.gbif.utils.file.tabular.JacksonCsvFileReader;
import org.gbif.utils.file.tabular.TabularDataFileReader;

public class TabularFiles {
    public static TabularDataFileReader<List<String>> newTabularFileReader(Reader reader, char delimiterChar, String endOfLineSymbols, Character quoteChar, boolean headerLine) throws IOException {
        return TabularFiles.newTabularFileReader(reader, delimiterChar, endOfLineSymbols, quoteChar, headerLine, null);
    }

    public static TabularDataFileReader<List<String>> newTabularFileReader(Reader reader, char delimiterChar, String endOfLineSymbols, Character quoteChar, boolean headerLine, Integer lineToSkipBeforeHeader) throws IOException {
        Preconditions.checkNotNull(reader, "A Reader must be provided");
        Preconditions.checkNotNull(endOfLineSymbols, "A endOfLineSymbols must be provided");
        return new JacksonCsvFileReader(reader, delimiterChar, endOfLineSymbols, quoteChar, headerLine, lineToSkipBeforeHeader);
    }

    public static TabularDataFileReader<List<String>> newTabularFileReader(Reader reader, char delimiterChar, boolean headerLine) throws IOException {
        return new JacksonCsvFileReader(reader, delimiterChar, new String(CsvSchema.DEFAULT_LINEFEED), Character.valueOf('\"'), headerLine);
    }
}

