/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.gbif.utils.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InputStreamUtils.class);

    public InputStream classpathStream(String path) {
        InputStream in = null;
        URL url = this.getClass().getClassLoader().getResource(path);
        if (url != null) {
            try {
                in = url.openStream();
            }
            catch (IOException e) {
                LOG.warn("Cant open classpath input stream " + path, (Throwable)e);
            }
        }
        return in;
    }

    public String readEntireStream(InputStream source) {
        return this.readEntireStream(source, FileUtils.UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readEntireStream(InputStream source, String encoding) {
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException("Unsupported encoding " + encoding);
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = source.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            LOG.error("Caught exception", (Throwable)e);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException e) {
                LOG.error("Caught exception", (Throwable)e);
            }
        }
        try {
            return result.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Could not decode stream as " + encoding);
        }
    }
}

