/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.NameImpl;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.util.logging.Logging;
import org.geotools.xlink.XLINK;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xml.XSD;
import org.geotools.xs.XS;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;

public class GMLEncodingUtils {
    static Logger LOGGER = Logging.getLogger((String)"org.geotools.gml");
    XSD gml;

    public GMLEncodingUtils(XSD gml) {
        this.gml = gml;
    }

    public List AbstractFeatureType_getProperties(Object object, XSDElementDeclaration element, SchemaIndex schemaIndex, Set<String> toFilter, Configuration configuration) {
        XSDElementDeclaration e;
        String typeName;
        QName qualifiedTypeName;
        XSDTypeDefinition type;
        Feature feature = (Feature)object;
        if (feature.getUserData().get("xlink:id") != null) {
            return Collections.EMPTY_LIST;
        }
        FeatureType featureType = feature.getType();
        String namespace = featureType.getName().getNamespaceURI();
        if (namespace == null) {
            namespace = element.getTargetNamespace();
        }
        if ((type = schemaIndex.getTypeDefinition(qualifiedTypeName = new QName(namespace, typeName = featureType.getName().getLocalPart()))) == null && (e = schemaIndex.getElementDeclaration(qualifiedTypeName)) != null) {
            type = e.getTypeDefinition();
        }
        if (type == null) {
            if (featureType instanceof SimpleFeatureType) {
                LOGGER.fine("Could find type for " + typeName + " in the schema, generating type from feature.");
                type = this.createXmlTypeFromFeatureType((SimpleFeatureType)featureType, schemaIndex, toFilter);
            } else {
                e = (XSDElementDeclaration)feature.getDescriptor().getUserData().get(XSDElementDeclaration.class);
                if (e != null) {
                    type = e.getTypeDefinition();
                } else {
                    throw new RuntimeException("Could not find type for " + qualifiedTypeName + " in schema");
                }
            }
        }
        List particles = Schemas.getChildElementParticles((XSDTypeDefinition)type, (boolean)true);
        ArrayList<Object[]> properties = new ArrayList<Object[]>();
        for (int i = 0; i < particles.size(); ++i) {
            XSDParticle particle = (XSDParticle)particles.get(i);
            XSDElementDeclaration attribute = (XSDElementDeclaration)particle.getContent();
            if (attribute.isElementDeclarationReference()) {
                attribute = attribute.getResolvedElementDeclaration();
            }
            if (this.gml.qName("boundedBy").equals(new QName(attribute.getTargetNamespace(), attribute.getName()))) {
                BoundingBox bounds = this.getBoundedBy(feature, configuration);
                if (bounds == null) continue;
                properties.add(new Object[]{particle, bounds});
                continue;
            }
            if (featureType instanceof SimpleFeatureType) {
                boolean skip = false;
                if (this.gml.getNamespaceURI().equals(attribute.getTargetNamespace())) {
                    for (int j = i + 1; j < particles.size(); ++j) {
                        XSDParticle particle2 = (XSDParticle)particles.get(j);
                        XSDElementDeclaration attribute2 = (XSDElementDeclaration)particle2.getContent();
                        if (attribute2.isElementDeclarationReference()) {
                            attribute2 = attribute2.getResolvedElementDeclaration();
                        }
                        if (!attribute2.getName().equals(attribute.getName())) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip || !this.isValidDescriptor((ComplexType)featureType, new NameImpl(attribute.getName()))) continue;
                Object attributeValue = ((SimpleFeature)feature).getAttribute(attribute.getName());
                if (attributeValue != null && attributeValue instanceof Geometry) {
                    Object obj = ((Geometry)attributeValue).getUserData();
                    HashMap<Class<CoordinateReferenceSystem>, CoordinateReferenceSystem> userData = new HashMap<Class<CoordinateReferenceSystem>, CoordinateReferenceSystem>();
                    if (obj != null && obj instanceof Map) {
                        userData.putAll((Map)obj);
                    }
                    userData.put(CoordinateReferenceSystem.class, featureType.getCoordinateReferenceSystem());
                    ((Geometry)attributeValue).setUserData(userData);
                }
                properties.add(new Object[]{particle, attributeValue});
                continue;
            }
            NameImpl propertyName = new NameImpl(attribute.getTargetNamespace(), attribute.getName());
            if (!this.isValidDescriptor((ComplexType)featureType, propertyName)) continue;
            for (Property property : feature.getProperties((Name)propertyName)) {
                Object value;
                if (property instanceof ComplexAttribute) {
                    value = property;
                } else if (property instanceof GeometryAttribute) {
                    value = property.getValue();
                    if (value != null) {
                        Geometry geometry = (Geometry)value;
                        CoordinateReferenceSystem crs = ((GeometryAttribute)property).getDescriptor().getCoordinateReferenceSystem();
                        HashMap<Class<CoordinateReferenceSystem>, CoordinateReferenceSystem> userData = new HashMap<Class<CoordinateReferenceSystem>, CoordinateReferenceSystem>();
                        Object obj = geometry.getUserData();
                        if (obj != null && obj instanceof Map) {
                            userData.putAll((Map)obj);
                        }
                        userData.put(CoordinateReferenceSystem.class, crs);
                        geometry.setUserData(userData);
                    }
                } else {
                    value = property.getValue();
                }
                properties.add(new Object[]{particle, value});
            }
        }
        return properties;
    }

    public XSDTypeDefinition createXmlTypeFromFeatureType(SimpleFeatureType featureType, SchemaIndex schemaIndex, Set<String> toFilter) {
        Document dom;
        XSDFactory f = XSDFactory.eINSTANCE;
        try {
            dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        XSDComplexTypeDefinition type = f.createXSDComplexTypeDefinition();
        type.setTargetNamespace(featureType.getName().getNamespaceURI());
        type.setName(featureType.getTypeName() + "Type");
        type.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        type.setBaseTypeDefinition(schemaIndex.getTypeDefinition(this.gml.qName("AbstractFeatureType")));
        XSDModelGroup group = f.createXSDModelGroup();
        group.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        List attributes = featureType.getAttributeDescriptors();
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeDescriptor attribute = (AttributeDescriptor)attributes.get(i);
            if (toFilter.contains(attribute.getLocalName())) continue;
            XSDElementDeclaration element = f.createXSDElementDeclaration();
            element.setName(attribute.getLocalName());
            element.setNillable(attribute.isNillable());
            if (attribute instanceof GeometryDescriptor) {
                Class binding = attribute.getType().getBinding();
                if (Point.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(this.gml.qName("PointPropertyType")));
                } else if (LineString.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(this.gml.qName("LineStringPropertyType")));
                } else if (Polygon.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(this.gml.qName("PolygonPropertyType")));
                } else if (MultiPoint.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(this.gml.qName("MultiPointPropertyType")));
                } else if (MultiLineString.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(this.gml.qName("MultiLineStringPropertyType")));
                } else if (MultiPolygon.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(this.gml.qName("MultiPolygonPropertyType")));
                } else {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(this.gml.qName("GeometryPropertyType")));
                }
            } else {
                element.setTypeDefinition(schemaIndex.getTypeDefinition(XS.STRING));
            }
            XSDParticle particle = f.createXSDParticle();
            particle.setMinOccurs(attribute.getMinOccurs());
            particle.setMaxOccurs(attribute.getMaxOccurs());
            particle.setContent((XSDParticleContent)element);
            particle.setElement(dom.createElementNS("http://www.w3.org/2001/XMLSchema", "element"));
            group.getContents().add((Object)particle);
        }
        XSDParticle particle = f.createXSDParticle();
        particle.setContent((XSDParticleContent)group);
        particle.setElement(dom.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence"));
        type.setContent((XSDComplexTypeContent)particle);
        return type;
    }

    private boolean isValidDescriptor(ComplexType type, Name name) {
        if (type.getDescriptor(name) != null) {
            return true;
        }
        if (type.getSuper() instanceof ComplexType) {
            return this.isValidDescriptor((ComplexType)type.getSuper(), name);
        }
        return false;
    }

    private BoundingBox getBoundedBy(Feature feature, Configuration configuration) {
        if (configuration.hasProperty(GMLConfiguration.NO_FEATURE_BOUNDS)) {
            return null;
        }
        BoundingBox bounds = feature.getBounds();
        if (bounds.isEmpty() && (feature.getDefaultGeometryProperty() == null || feature.getDefaultGeometryProperty().getValue() == null)) {
            return null;
        }
        return bounds;
    }

    public Object GeometryPropertyType_getProperty(Geometry geometry, QName name) {
        return this.GeometryPropertyType_getProperty(geometry, name, true, false);
    }

    public Object GeometryPropertyType_getProperty(Geometry geometry, QName name, boolean includeAbstractGeometry) {
        return this.GeometryPropertyType_getProperty(geometry, name, includeAbstractGeometry, false);
    }

    public Object GeometryPropertyType_getProperty(Geometry geometry, QName name, boolean includeAbstractGeometry, boolean makeEmpty) {
        if (name.equals(this.gml.qName("Point")) || name.equals(this.gml.qName("LineString")) || name.equals(this.gml.qName("Polygon")) || name.equals(this.gml.qName("MultiPoint")) || name.equals(this.gml.qName("MultiLineString")) || name.equals(this.gml.qName("MultiPolygon")) || name.equals(this.gml.qName("MultiSurface")) || name.equals(this.gml.qName("AbstractSurface")) || name.equals(this.gml.qName("_Surface")) || name.equals(this.gml.qName("_Curve")) || name.equals(this.gml.qName("AbstractCurve")) || name.equals(this.gml.qName("MultiCurve")) || includeAbstractGeometry && (name.equals(this.gml.qName("_Geometry")) || name.equals(this.gml.qName("AbstractGeometry")))) {
            if (GMLEncodingUtils.isEmpty(geometry) || makeEmpty) {
                return null;
            }
            return geometry;
        }
        if (geometry.getUserData() instanceof Map) {
            Map clientProperties = (Map)((Map)geometry.getUserData()).get(Attributes.class);
            Name cname = GMLEncodingUtils.toTypeName(name);
            if (clientProperties != null && clientProperties.keySet().contains(cname)) {
                return clientProperties.get(cname);
            }
        }
        if (XLINK.HREF.equals(name)) {
            String id = this.getID(geometry);
            if ((makeEmpty || GMLEncodingUtils.isEmpty(geometry)) && id != null) {
                return "#" + id;
            }
        }
        return null;
    }

    private static Name toTypeName(QName name) {
        if ("".equals(name.getNamespaceURI())) {
            return new NameImpl(name.getLocalPart());
        }
        return new NameImpl(name.getNamespaceURI(), name.getLocalPart());
    }

    public List GeometryPropertyType_getProperties(Geometry geometry) {
        return null;
    }

    public static boolean isEmpty(Geometry geometry) {
        if (geometry.isEmpty()) {
            return !(geometry instanceof GeometryCollection) || ((GeometryCollection)geometry).getNumGeometries() == 0;
        }
        return false;
    }

    public String getID(Geometry g) {
        return this.getMetadata(g, "gml:id");
    }

    public void setID(Geometry g, String id) {
        this.setMetadata(g, "gml:id", id);
    }

    public String getName(Geometry g) {
        return this.getMetadata(g, "gml:name");
    }

    public void setName(Geometry g, String name) {
        this.setMetadata(g, "gml:name", name);
    }

    public String getDescription(Geometry g) {
        return this.getMetadata(g, "gml:description");
    }

    public void setDescription(Geometry g, String description) {
        this.setMetadata(g, "gml:description", description);
    }

    String getMetadata(Geometry g, String metadata) {
        if (g.getUserData() instanceof Map) {
            Map userData = (Map)g.getUserData();
            return (String)userData.get(metadata);
        }
        return null;
    }

    void setMetadata(Geometry g, String metadata, String value) {
        if (g.getUserData() == null) {
            g.setUserData(new HashMap());
        }
        if (g.getUserData() instanceof Map) {
            ((Map)g.getUserData()).put(metadata, value);
        }
    }
}

