/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.terms;

import java.util.Map;
import java.util.regex.Pattern;
import org.gbif.dwc.terms.Term;

public class Terms {
    private static final Pattern NULL_PATTERN = Pattern.compile("^\\s*(\\\\N|\\\\?NULL)\\s*$");

    private Terms() {
    }

    public static String getValueOfFirst(Map<Term, String> record, Term ... terms) {
        for (Term t : terms) {
            String val;
            if (!record.containsKey(t) || (val = Terms.clean(record.get(t))) == null) continue;
            return val;
        }
        return null;
    }

    private static String clean(String str) {
        if (Terms.isTermValueBlank(str)) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    public static boolean isTermValueBlank(String termValue) {
        return termValue == null || termValue.isEmpty() || NULL_PATTERN.matcher(termValue).find();
    }
}

