/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.feature;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geojson.GeoJSONUtil;
import org.geotools.geojson.feature.AttributeIO;
import org.geotools.geojson.feature.CRSHandler;
import org.geotools.geojson.feature.DefaultAttributeIO;
import org.geotools.geojson.feature.FeatureCollectionHandler;
import org.geotools.geojson.feature.FeatureHandler;
import org.geotools.geojson.feature.FeatureTypeAttributeIO;
import org.geotools.geojson.feature.FeatureTypeHandler;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONStreamAware;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureJSON {
    GeometryJSON gjson;
    SimpleFeatureType featureType;
    AttributeIO attio;
    boolean encodeFeatureBounds = false;
    boolean encodeFeatureCollectionBounds = false;
    boolean encodeFeatureCRS = false;
    boolean encodeFeatureCollectionCRS = false;
    boolean encodeNullValues = false;

    public FeatureJSON() {
        this(new GeometryJSON());
    }

    public FeatureJSON(GeometryJSON gjson) {
        this.gjson = gjson;
        this.attio = new DefaultAttributeIO();
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
        this.attio = new FeatureTypeAttributeIO(featureType);
    }

    public void setEncodeFeatureBounds(boolean encodeFeatureBounds) {
        this.encodeFeatureBounds = encodeFeatureBounds;
    }

    public boolean isEncodeFeatureBounds() {
        return this.encodeFeatureBounds;
    }

    public void setEncodeFeatureCollectionBounds(boolean encodeFeatureCollectionBounds) {
        this.encodeFeatureCollectionBounds = encodeFeatureCollectionBounds;
    }

    public boolean isEncodeFeatureCollectionBounds() {
        return this.encodeFeatureCollectionBounds;
    }

    public void setEncodeFeatureCRS(boolean encodeFeatureCRS) {
        this.encodeFeatureCRS = encodeFeatureCRS;
    }

    public boolean isEncodeFeatureCRS() {
        return this.encodeFeatureCRS;
    }

    public void setEncodeFeatureCollectionCRS(boolean encodeFeatureCollectionCRS) {
        this.encodeFeatureCollectionCRS = encodeFeatureCollectionCRS;
    }

    public boolean isEncodeFeatureCollectionCRS() {
        return this.encodeFeatureCollectionCRS;
    }

    public void setEncodeNullValues(boolean encodeNullValues) {
        this.encodeNullValues = encodeNullValues;
    }

    public boolean isEncodeNullValues() {
        return this.encodeNullValues;
    }

    public void writeFeature(SimpleFeature feature, Object output) throws IOException {
        GeoJSONUtil.encode(new FeatureEncoder(feature).toJSONString(), output);
    }

    public void writeFeature(SimpleFeature feature, OutputStream output) throws IOException {
        this.writeFeature(feature, (Object)output);
    }

    public String toString(SimpleFeature feature) throws IOException {
        StringWriter w = new StringWriter();
        this.writeFeature(feature, w);
        return w.toString();
    }

    public SimpleFeature readFeature(Object input) throws IOException {
        return GeoJSONUtil.parse(new FeatureHandler(this.featureType != null ? new SimpleFeatureBuilder(this.featureType) : null, this.attio), input, false);
    }

    public SimpleFeature readFeature(InputStream input) throws IOException {
        return this.readFeature((Object)input);
    }

    public void writeFeatureCollection(FeatureCollection features, Object output) throws IOException {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "FeatureCollection");
        final ReferencedEnvelope bounds = features.getBounds();
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        if (this.encodeFeatureCollectionBounds) {
            obj.put("bbox", new JSONStreamAware(){

                public void writeJSONString(Writer out) throws IOException {
                    JSONArray.writeJSONString(Arrays.asList(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()), (Writer)out);
                }
            });
        }
        if (crs != null && (this.encodeFeatureCollectionCRS || !this.isStandardCRS(crs))) {
            obj.put("crs", this.createCRS(crs));
        }
        obj.put("features", new FeatureCollectionEncoder(features, this.gjson));
        GeoJSONUtil.encode(obj, output);
    }

    private boolean isStandardCRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return true;
        }
        try {
            CoordinateReferenceSystem standardCRS = CRS.decode((String)"EPSG:4326");
            return CRS.equalsIgnoreMetadata((Object)crs, (Object)standardCRS);
        }
        catch (Exception unexpected) {
            return false;
        }
    }

    public void writeFeatureCollection(FeatureCollection features, OutputStream output) throws IOException {
        this.writeFeatureCollection(features, (Object)output);
    }

    public FeatureCollection readFeatureCollection(Object input) throws IOException {
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, null);
        FeatureCollectionIterator it = (FeatureCollectionIterator)this.streamFeatureCollection(input);
        while (it.hasNext()) {
            features.add(it.next());
        }
        if (features.getSchema() != null && features.getSchema().getCoordinateReferenceSystem() == null && it.getHandler().getCRS() != null) {
            try {
                return new ForceCoordinateSystemFeatureResults(features, it.getHandler().getCRS());
            }
            catch (SchemaException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        return features;
    }

    public FeatureCollection readFeatureCollection(InputStream input) throws IOException {
        return this.readFeatureCollection((Object)input);
    }

    public FeatureIterator<SimpleFeature> streamFeatureCollection(Object input) throws IOException {
        return new FeatureCollectionIterator(input);
    }

    public String toString(FeatureCollection features) throws IOException {
        StringWriter w = new StringWriter();
        this.writeFeatureCollection(features, w);
        return w.toString();
    }

    public void writeCRS(CoordinateReferenceSystem crs, Object output) throws IOException {
        GeoJSONUtil.encode(this.createCRS(crs), output);
    }

    public void writeCRS(CoordinateReferenceSystem crs, OutputStream output) throws IOException {
        this.writeCRS(crs, (Object)output);
    }

    Map<String, Object> createCRS(CoordinateReferenceSystem crs) throws IOException {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "name");
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        if (crs == null) {
            props.put("name", "EPSG:4326");
        } else {
            try {
                String identifier = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
                props.put("name", identifier);
            }
            catch (FactoryException e) {
                throw (IOException)new IOException("Error looking up crs identifier").initCause(e);
            }
        }
        obj.put("properties", props);
        return obj;
    }

    public CoordinateReferenceSystem readCRS(Object input) throws IOException {
        return GeoJSONUtil.parse(new CRSHandler(), input, false);
    }

    public CoordinateReferenceSystem readCRS(InputStream input) throws IOException {
        return this.readCRS((Object)input);
    }

    public SimpleFeatureType readFeatureCollectionSchema(Object input, boolean nullValuesEncoded) throws IOException {
        return GeoJSONUtil.parse(new FeatureTypeHandler(nullValuesEncoded), input, false);
    }

    public SimpleFeatureType readFeatureCollectionSchema(InputStream input, boolean nullValuesEncoded) throws IOException {
        return this.readFeatureCollectionSchema((Object)input, false);
    }

    public String toString(CoordinateReferenceSystem crs) throws IOException {
        StringWriter writer = new StringWriter();
        this.writeCRS(crs, writer);
        return writer.toString();
    }

    class FeatureCollectionIterator
    implements FeatureIterator<SimpleFeature> {
        Reader reader;
        FeatureCollectionHandler handler;
        JSONParser parser;
        SimpleFeature next;

        FeatureCollectionIterator(Object input) {
            try {
                this.reader = GeoJSONUtil.toReader(input);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.parser = new JSONParser();
        }

        FeatureCollectionHandler getHandler() {
            return this.handler;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.handler == null) {
                this.handler = new FeatureCollectionHandler(FeatureJSON.this.featureType, FeatureJSON.this.attio);
            }
            this.next = this.readNext();
            return this.next != null;
        }

        @Override
        public SimpleFeature next() {
            SimpleFeature feature = this.next;
            this.next = null;
            return feature;
        }

        SimpleFeature readNext() {
            try {
                this.parser.parse(this.reader, (ContentHandler)this.handler, true);
                return this.handler.getValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            this.reader = null;
            this.parser = null;
            this.handler = null;
        }
    }

    class FeatureCollectionEncoder
    implements JSONStreamAware {
        FeatureCollection features;
        GeometryJSON gjson;

        public FeatureCollectionEncoder(FeatureCollection features, GeometryJSON gjson) {
            this.features = features;
            this.gjson = gjson;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeJSONString(Writer out) throws IOException {
            FeatureEncoder featureEncoder = new FeatureEncoder((SimpleFeatureType)this.features.getSchema());
            out.write("[");
            FeatureIterator i = this.features.features();
            try {
                if (i.hasNext()) {
                    SimpleFeature f = (SimpleFeature)i.next();
                    out.write(featureEncoder.toJSONString(f));
                    while (i.hasNext()) {
                        out.write(",");
                        f = (SimpleFeature)i.next();
                        out.write(featureEncoder.toJSONString(f));
                    }
                }
            }
            finally {
                if (i != null) {
                    i.close();
                }
            }
            out.write("]");
            out.flush();
        }
    }

    class FeatureEncoder
    implements JSONAware {
        SimpleFeatureType featureType;
        SimpleFeature feature;

        public FeatureEncoder(SimpleFeature feature) {
            this(feature.getType());
            this.feature = feature;
        }

        public FeatureEncoder(SimpleFeatureType featureType) {
            this.featureType = featureType;
        }

        public String toJSONString(SimpleFeature feature) {
            CoordinateReferenceSystem crs;
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            GeoJSONUtil.entry("type", "Feature", sb);
            sb.append(",");
            if (FeatureJSON.this.encodeFeatureCRS && (crs = feature.getFeatureType().getCoordinateReferenceSystem()) != null) {
                try {
                    GeoJSONUtil.string("crs", sb).append(":");
                    sb.append(FeatureJSON.this.toString(crs)).append(",");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (FeatureJSON.this.encodeFeatureBounds) {
                BoundingBox bbox = feature.getBounds();
                GeoJSONUtil.string("bbox", sb).append(":");
                sb.append(FeatureJSON.this.gjson.toString(bbox)).append(",");
            }
            if (feature.getDefaultGeometry() != null) {
                GeoJSONUtil.string("geometry", sb).append(":").append(FeatureJSON.this.gjson.toString((Geometry)feature.getDefaultGeometry()));
                sb.append(",");
            }
            int gindex = this.featureType.getGeometryDescriptor() != null ? this.featureType.indexOf(this.featureType.getGeometryDescriptor().getLocalName()) : -1;
            GeoJSONUtil.string("properties", sb).append(":").append("{");
            boolean attributesWritten = false;
            for (int i = 0; i < this.featureType.getAttributeCount(); ++i) {
                AttributeDescriptor ad = this.featureType.getDescriptor(i);
                if (i == gindex) continue;
                Object value = feature.getAttribute(i);
                if (!FeatureJSON.this.encodeNullValues && value == null) continue;
                attributesWritten = true;
                if (value instanceof Envelope) {
                    GeoJSONUtil.array(ad.getLocalName(), FeatureJSON.this.gjson.toString((Envelope)value), sb);
                } else if (value instanceof BoundingBox) {
                    GeoJSONUtil.array(ad.getLocalName(), FeatureJSON.this.gjson.toString((BoundingBox)value), sb);
                } else if (value instanceof Geometry) {
                    GeoJSONUtil.string(ad.getLocalName(), sb).append(":").append(FeatureJSON.this.gjson.toString((Geometry)value));
                } else {
                    GeoJSONUtil.entry(ad.getLocalName(), value, sb);
                }
                sb.append(",");
            }
            if (attributesWritten) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("},");
            GeoJSONUtil.entry("id", feature.getID(), sb);
            sb.append("}");
            return sb.toString();
        }

        public String toJSONString() {
            return this.toJSONString(this.feature);
        }
    }
}

