/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class TermDump {
    private File index;
    private Writer output;

    public TermDump(File index, Writer output) {
        this.index = index;
        this.output = output;
    }

    public void dump() throws IOException {
        DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((Path)this.index.toPath()));
        Fields fields = MultiFields.getFields((IndexReader)reader);
        PrintWriter pw = new PrintWriter(this.output);
        for (String field : fields) {
            pw.println(field);
        }
        reader.close();
    }

    public static void main(String[] args) {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"Output file name - defaults to standard output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        Option o = OptionBuilder.create((char)'o');
        OptionBuilder.withLongOpt((String)"index");
        OptionBuilder.withDescription((String)"Lucene index directory - defaults to /data/lucene/namematching/cb");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIR");
        Option i = OptionBuilder.create((char)'i');
        options.addOption(o);
        options.addOption(i);
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            String of = cmd.getOptionValue('o', "-");
            OutputStreamWriter output = of == null || of.equals("-") ? new OutputStreamWriter(System.out) : new FileWriter(of);
            File index = new File(cmd.getOptionValue('i', "/data/lucene/namematching/cb"));
            TermDump dumper = new TermDump(index, output);
            dumper.dump();
            ((Writer)output).close();
        }
        catch (ParseException ex) {
            System.err.println("Unable to parse command line: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

