/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.util;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CleanedScientificName {
    private static final Pattern SPACES = Pattern.compile("\\s+", 256);
    private static final Substitute[] PUNCT_TRANSLATE = new Substitute[]{new Substitute('\u00a0', ' '), new Substitute('\u00ad', '-'), new Substitute('\u2010', '-'), new Substitute('\u2011', '-'), new Substitute('\u2012', '-'), new Substitute('\u2013', '-'), new Substitute('\u2014', '-'), new Substitute('\u2015', '-'), new Substitute('\u2018', '\''), new Substitute('\u2019', '\''), new Substitute('\u201a', '\''), new Substitute('\u201b', '\''), new Substitute('\u201c', '\"'), new Substitute('\u201d', '\"'), new Substitute('\u201e', '\"'), new Substitute('\u201f', '\"'), new Substitute(Character.valueOf('\u2027'), ""), new Substitute('\u2028', ' '), new Substitute('\u2029', ' '), new Substitute(Character.valueOf('\u202a'), ""), new Substitute(Character.valueOf('\u202b'), ""), new Substitute(Character.valueOf('\u202c'), ""), new Substitute(Character.valueOf('\u202d'), ""), new Substitute(Character.valueOf('\u202e'), ""), new Substitute('\u202f', ' ')};
    private static final Substitute[] BASIC_TRANSLATE = new Substitute[]{new Substitute('\u00a1', '!'), new Substitute('\u00a2', 'c'), new Substitute('\u00a3', '#'), new Substitute('\u00a4', '#'), new Substitute('\u00a5', 'Y'), new Substitute('\u00a6', '|'), new Substitute('\u00a7', '$'), new Substitute(Character.valueOf('\u00a8'), ""), new Substitute('\u00a9', 'c'), new Substitute(Character.valueOf('\u00aa'), ""), new Substitute(Character.valueOf('\u00ab'), "<<"), new Substitute('\u00ac', '~'), new Substitute(Character.valueOf('\u00d7'), " x "), new Substitute('\u00ae', 'r'), new Substitute('\u00af', ' '), new Substitute('\u00b0', 'o'), new Substitute(Character.valueOf('\u00b1'), "+-"), new Substitute('\u00b2', '2'), new Substitute('\u00b3', '3'), new Substitute(Character.valueOf('\u00b4'), ""), new Substitute('\u00b5', 'u'), new Substitute('\u00b6', '@'), new Substitute('\u00b7', '.'), new Substitute(Character.valueOf('\u00b8'), ""), new Substitute('\u00b9', '1'), new Substitute(Character.valueOf('\u00bb'), ">>"), new Substitute('\u00bf', '?'), new Substitute(Character.valueOf('\u00df'), "ss"), new Substitute(Character.valueOf('\u03b1'), " alpha "), new Substitute(Character.valueOf('\u03b2'), " beta "), new Substitute(Character.valueOf('\u03b3'), " gamma "), new Substitute(Character.valueOf('\u03b4'), " delta "), new Substitute(Character.valueOf('\u03b5'), " epsilon "), new Substitute(Character.valueOf('\u03b6'), " zeta "), new Substitute(Character.valueOf('\u03b7'), " eta"), new Substitute(Character.valueOf('\u03b8'), " theta "), new Substitute(Character.valueOf('\u03ba'), " kappa "), new Substitute(Character.valueOf('\u03bb'), " lambda "), new Substitute(Character.valueOf('\u03bc'), " mu "), new Substitute(Character.valueOf('\u03bd'), " nu "), new Substitute(Character.valueOf('\u03be'), " xi "), new Substitute(Character.valueOf('\u03bf'), " omicron "), new Substitute(Character.valueOf('\u03c0'), " pi "), new Substitute(Character.valueOf('\u03c1'), " rho "), new Substitute(Character.valueOf('\u03c2'), " sigma "), new Substitute(Character.valueOf('\u03c3'), " sigma"), new Substitute(Character.valueOf('\u03c4'), " tau "), new Substitute(Character.valueOf('\u03c5'), " upsilon "), new Substitute(Character.valueOf('\u03c6'), " phi "), new Substitute(Character.valueOf('\u03c7'), " chi "), new Substitute(Character.valueOf('\u03c8'), " psi "), new Substitute(Character.valueOf('\u03c9'), " omega "), new Substitute(Character.valueOf('\u1e9e'), "SS"), new Substitute('\u2016', '|'), new Substitute('\u2017', '-'), new Substitute('\u2020', '*'), new Substitute('\u2021', '*'), new Substitute('\u2022', '*'), new Substitute('\u2023', '*'), new Substitute('\u2024', '.'), new Substitute('\u2025', '.'), new Substitute('\u2026', '.'), new Substitute('\u2030', '%'), new Substitute('\u2031', '%'), new Substitute('\u2032', '\''), new Substitute('\u2033', '\"'), new Substitute('\u2034', '\"'), new Substitute('\u2035', '\''), new Substitute('\u2036', '\"'), new Substitute('\u2037', '\"'), new Substitute('\u2038', '^'), new Substitute('\u2039', '<'), new Substitute('\u203a', '>'), new Substitute('\u203b', '*'), new Substitute(Character.valueOf('\u203c'), "!!"), new Substitute(Character.valueOf('\u203d'), "?!"), new Substitute('\u203e', '-'), new Substitute('\u203f', '_'), new Substitute('\u2040', '-'), new Substitute('\u2041', '^'), new Substitute('\u2042', '*'), new Substitute('\u2043', '*'), new Substitute('\u2044', '/'), new Substitute('\u2045', '['), new Substitute('\u2046', ']'), new Substitute(Character.valueOf('\u2047'), "??"), new Substitute(Character.valueOf('\u2715'), " x "), new Substitute(Character.valueOf('\u2a09'), " x "), new Substitute(Character.valueOf('\u2a7f'), " x ")};
    private String source;
    private String name;
    private String normalised;
    private String basic;
    private static Map<Character, String> PUNCT_MAP = null;
    private static Map<Character, String> BASIC_MAP = null;

    protected static synchronized Map<Character, String> getPunctuationMap() {
        if (PUNCT_MAP == null) {
            PUNCT_MAP = new HashMap<Character, String>(100);
            for (Substitute sub : PUNCT_TRANSLATE) {
                PUNCT_MAP.put(sub.ch, sub.sub);
            }
        }
        return PUNCT_MAP;
    }

    protected static synchronized Map<Character, String> getBasicMap() {
        if (BASIC_MAP == null) {
            BASIC_MAP = new HashMap<Character, String>(100);
            for (Substitute sub : BASIC_TRANSLATE) {
                BASIC_MAP.put(sub.ch, sub.sub);
            }
        }
        return BASIC_MAP;
    }

    protected String normaliseSpaces(String name) {
        Matcher matcher = SPACES.matcher(name);
        return matcher.replaceAll(" ").trim();
    }

    protected String translate(String name, Map<Character, String> map) {
        StringBuilder builder = new StringBuilder(name.length());
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            String r = map.get(Character.valueOf(ch));
            if (r == null) {
                builder.append(ch);
                continue;
            }
            builder.append(r);
        }
        return builder.toString();
    }

    public CleanedScientificName(String source) {
        assert (source != null);
        this.source = source;
        this.name = null;
        this.normalised = null;
        this.basic = null;
    }

    protected String buildName(String source) {
        return this.normaliseSpaces(source);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.buildName(this.source);
        }
        return this.name;
    }

    protected String buildNormalised(String name) {
        name = Normalizer.normalize(name, Normalizer.Form.NFKC);
        name = this.translate(name, this.getPunctuationMap());
        return this.normaliseSpaces(name);
    }

    public String getNormalised() {
        if (this.normalised == null) {
            this.normalised = this.buildNormalised(this.getName());
        }
        return this.normalised;
    }

    public boolean hasNormalised() {
        return !this.getName().equals(this.getNormalised());
    }

    protected String buildBasic(String name) {
        name = Normalizer.normalize(name, Normalizer.Form.NFD);
        name = this.translate(name, this.getBasicMap());
        name = this.normaliseSpaces(name);
        int len = name.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch >= '\u0080') continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    public String getBasic() {
        if (this.basic == null) {
            this.basic = this.buildBasic(this.getNormalised());
        }
        return this.basic;
    }

    public boolean hasBasic() {
        return !this.getNormalised().equals(this.getBasic());
    }

    protected static class Substitute {
        public Character ch;
        public String sub;

        public Substitute(Character ch, String sub) {
            this.ch = ch;
            this.sub = sub;
        }

        public Substitute(char ch, char sub) {
            this.ch = Character.valueOf(ch);
            this.sub = new String(new char[]{sub});
        }
    }
}

