/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.analysis.layers;

import au.org.ala.layers.client.Client;
import au.org.ala.layers.intersect.IntersectConfig;
import au.org.ala.spatial.analysis.layers.CalcThread;
import au.org.ala.spatial.analysis.layers.ToDiskThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class LayerDistanceIndex {
    public static final String LAYER_DISTANCE_FILE = "layerDistances.properties";
    private static final Logger logger = Logger.getLogger(LayerDistanceIndex.class);

    public static void main(String[] args) throws InterruptedException {
        logger.info((Object)"args[0] = threadcount, e.g. 1");
        logger.info((Object)"or");
        logger.info((Object)"args[0] = threadcount, e.g. 1");
        logger.info((Object)"args[1] = list of layer pairs to rerun, e.g. el813_el814,el813_el815,el814_el815");
        if (args.length < 1) {
            args = new String[]{"1"};
        }
        String[] pairs = null;
        if (args.length >= 2) {
            pairs = args[1].replace("_", " ").split(",");
        }
        LayerDistanceIndex ldi = new LayerDistanceIndex();
        ldi.occurrencesUpdate(Integer.parseInt(args[0]), pairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Double> loadDistances() {
        ConcurrentHashMap<String, Double> map = new ConcurrentHashMap<String, Double>();
        BufferedReader br = null;
        try {
            String line;
            File file = new File(IntersectConfig.getAlaspatialOutputPath() + LAYER_DISTANCE_FILE);
            if (!new File(IntersectConfig.getAlaspatialOutputPath()).exists()) {
                new File(IntersectConfig.getAlaspatialOutputPath()).mkdirs();
            }
            if (!file.exists()) {
                FileUtils.writeStringToFile((File)file, (String)"");
            }
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                String[] keyvalue = line.split("=");
                double d = Double.NaN;
                try {
                    d = Double.parseDouble(keyvalue[1]);
                }
                catch (Exception e) {
                    logger.info((Object)("cannot parse value in " + line));
                }
                map.put(keyvalue[0], d);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return map;
    }

    static String[] parseDomain(String domain) {
        if (domain == null || domain.length() == 0) {
            return null;
        }
        String[] domains = domain.split(",");
        for (int i = 0; i < domains.length; ++i) {
            domains[i] = domains[i].trim();
        }
        return domains;
    }

    static boolean isSameDomain(String[] domain1, String[] domain2) {
        if (domain1 == null || domain2 == null) {
            return true;
        }
        for (String s1 : domain1) {
            for (String s2 : domain2) {
                if (!s1.equalsIgnoreCase(s2)) continue;
                return true;
            }
        }
        return false;
    }

    public static void all() {
        try {
            LayerDistanceIndex ldi = new LayerDistanceIndex();
            ldi.occurrencesUpdate(1, null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(Map<String, Double> newDistances) {
        OutputStreamWriter fw = null;
        try {
            File layerDistancesFile = new File(IntersectConfig.getAlaspatialOutputPath() + LAYER_DISTANCE_FILE);
            if (!layerDistancesFile.exists()) {
                fw = new FileWriter(layerDistancesFile);
                fw.close();
            }
            fw = new FileWriter(layerDistancesFile, true);
            for (String key : newDistances.keySet()) {
                fw.write(key + "=" + newDistances.get(key) + "\n");
            }
            fw.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void occurrencesUpdate(int threadcount, String[] onlyThesePairs) throws InterruptedException {
        void var9_22;
        File layerDistancesFile = new File(IntersectConfig.getAlaspatialOutputPath() + LAYER_DISTANCE_FILE);
        if (!layerDistancesFile.exists()) {
            FileWriter fw = null;
            try {
                fw = new FileWriter(layerDistancesFile);
                fw.flush();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        Map<String, Double> map = LayerDistanceIndex.loadDistances();
        LinkedBlockingQueue<String> todo = new LinkedBlockingQueue<String>();
        if (onlyThesePairs != null && onlyThesePairs.length > 0) {
            for (String string : onlyThesePairs) {
                todo.add(string);
            }
        } else {
            File root = new File(IntersectConfig.getAlaspatialOutputPath());
            File[] dirs = root.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname != null && pathname.isDirectory();
                }
            });
            HashMap<String, String> domains = new HashMap<String, String>();
            for (File dir : dirs) {
                File[] files = new File(dir.getPath()).listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".grd") && pathname.getName().startsWith("el");
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    for (int j = i + 1; j < files.length; ++j) {
                        String key;
                        String domain2;
                        String file1 = files[i].getName().replace(".grd", "");
                        String file2 = files[j].getName().replace(".grd", "");
                        if (Client.getFieldDao().getFieldById(file1) == null || Client.getFieldDao().getFieldById(file2) == null) continue;
                        String domain1 = (String)domains.get(file1);
                        if (domain1 == null) {
                            String pid1 = Client.getFieldDao().getFieldById(file1).getSpid();
                            domain1 = Client.getLayerDao().getLayerById(Integer.parseInt(pid1)).getdomain();
                            domains.put(file1, domain1);
                        }
                        if ((domain2 = (String)domains.get(file2)) == null) {
                            String pid2 = Client.getFieldDao().getFieldById(file2).getSpid();
                            domain2 = Client.getLayerDao().getLayerById(Integer.parseInt(pid2)).getdomain();
                            domains.put(file2, domain2);
                        }
                        String string = key = file1.compareTo(file2) < 0 ? file1 + " " + file2 : file2 + " " + file1;
                        if (!LayerDistanceIndex.isSameDomain(LayerDistanceIndex.parseDomain(domain1), LayerDistanceIndex.parseDomain(domain2)) || map.containsKey(key) || todo.contains(key)) continue;
                        todo.put(key);
                    }
                }
            }
        }
        LinkedBlockingQueue<String> toDisk = new LinkedBlockingQueue<String>();
        CountDownLatch cdl = new CountDownLatch(todo.size());
        CalcThread[] threads = new CalcThread[threadcount];
        boolean bl = false;
        while (var9_22 < threadcount) {
            threads[var9_22] = new CalcThread(cdl, todo, toDisk);
            threads[var9_22].start();
            ++var9_22;
        }
        ToDiskThread toDiskThread = new ToDiskThread(IntersectConfig.getAlaspatialOutputPath() + LAYER_DISTANCE_FILE, toDisk);
        toDiskThread.start();
        cdl.await();
        for (int i = 0; i < threadcount; ++i) {
            threads[i].interrupt();
        }
        toDiskThread.interrupt();
    }
}

