/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.analysis.layers;

import au.org.ala.layers.grid.GridCutter;
import au.org.ala.layers.intersect.Grid;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

class CalcThread
extends Thread {
    private static final Logger logger = Logger.getLogger(CalcThread.class);
    CountDownLatch cdl;
    LinkedBlockingQueue<String> lbq;
    LinkedBlockingQueue<String> toDisk;

    public CalcThread(CountDownLatch cdl, LinkedBlockingQueue<String> lbq, LinkedBlockingQueue<String> toDisk) {
        this.cdl = cdl;
        this.lbq = lbq;
        this.toDisk = toDisk;
    }

    @Override
    public void run() {
        try {
            while (true) {
                String key = this.lbq.take();
                String[] layers = key.split(" ");
                try {
                    Double distance = this.calculateDistance(layers[0], layers[1]);
                    this.toDisk.put(key + "=" + distance);
                    logger.debug((Object)(key + "=" + distance));
                }
                catch (Exception e) {
                    logger.error((Object)(key + ":error"), (Throwable)e);
                }
                this.cdl.countDown();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private Double calculateDistance(String layer1, String layer2) {
        Grid g1 = Grid.getGridStandardized(GridCutter.getLayerPath("0.01", layer1));
        Grid g2 = Grid.getGridStandardized(GridCutter.getLayerPath("0.01", layer2));
        double minx = Math.max(g1.xmin, g2.xmin);
        double maxx = Math.min(g1.xmax, g2.xmax);
        double miny = Math.max(g1.ymin, g2.ymin);
        double maxy = Math.min(g1.ymax, g2.ymax);
        float[] d1 = g1.getGrid();
        float[] d2 = g2.getGrid();
        int count = 0;
        double sum = 0.0;
        for (double x = minx + g1.xres / 2.0; x < maxx; x += g1.xres) {
            for (double y = miny + g1.yres / 2.0; y < maxy; y += g1.xres) {
                double v1 = d1[(int)g1.getcellnumber(x, y)];
                double v2 = d2[(int)g2.getcellnumber(x, y)];
                if (Double.isNaN(v1) || Double.isNaN(v2)) continue;
                ++count;
                sum += Math.abs(v1 - v2);
            }
        }
        return sum / (double)count;
    }
}

